
public class ArbitraryCSCourse
{
	private Student[] students;
	private Grader grader;
	private double[][] studentGrades;
	private int numAssignments;
	private int nextAssignmentNum;
	
	public ArbitraryCSCourse(Student[] students, Grader grader, int numAssignments){
		this.students = students;
		this.grader = grader;
		this.numAssignments = numAssignments;
		this.studentGrades = new double[students.length][numAssignments];
		this.nextAssignmentNum = 0;
	}
	
	public double getGrade(int studentId)throws NotFoundException{
		for (int i = 0 ; i< students.length; i++){
			if (students[i].getId()==studentId){
				double studentGrade = 0;
				for(int j = 0 ; j<nextAssignmentNum; j++){
					studentGrade+=studentGrades[i][j];
				}
				return studentGrade/(nextAssignmentNum);
			}
		}
		throw new NotFoundException("student "+studentId);
	}
	
	public void collectAssignment()throws TooManyAssignmentsException{
		String assignDesc = "This is assignment number "+nextAssignmentNum+"--do a good job!";
		if (nextAssignmentNum>numAssignments){
			throw new TooManyAssignmentsException(nextAssignmentNum);
		}
		for (int i = 0; i<students.length; i++){
			String assignment = students[i].submitAssignment(nextAssignmentNum, assignDesc);
			double studentScore = grader.gradeAssignment(nextAssignmentNum, assignment);
			this.studentGrades[i][nextAssignmentNum]=studentScore;
		}
		this.nextAssignmentNum++;
	}
	
	public static void main(String[] args)
	{
		try{
			Student[] students = new Student[5];
			students[0]= new UndergradStudent("Sophie Moore", "Chemical Engineering", 2);
			students[1]= new ComputerScienceStudent("Alan Turing",1);
			students[2]= new MedievalStudiesStudent("Tammy Lin", 3);
			
			String thesis = "We consider a fractional order integro-differential equation with a " +
					"weakly singular convolution kernel. The equation with homogeneous Dirichlet " +
					"boundary conditions is reformulated as an abstract Cauchy problem, and " +
					"well-posedness is verified in the context of linear semigroup theory. Then we " +
					"formulate a continuous Galerkin method for the problem, and we prove stability " +
					"estimates. These are then used to prove a priori error estimates. The theory is " +
					"illustrated by a numerical example.";
			students[3]= new GradStudent("Phillip Davis", "Mathematics", thesis);
			students[4]= new ComputerScienceStudent("Larry Page",4);
			
			
			//Grader grader = new EasyGrader(); 
			//Grader grader = (GradStudent)students[3];
			Grader grader = new CSBiasedGrader();
			
			int numAssignments=10; 
			ArbitraryCSCourse course = new ArbitraryCSCourse(students, grader, numAssignments);
			course.collectAssignment();
			course.collectAssignment();
			course.collectAssignment();
			for (int i = 0; i<students.length; i++)
			{
				System.out.println(students[i].getName()+": "+course.getGrade(students[i].getId()));
			}
			
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		
	}
}
class TooManyAssignmentsException extends Exception{
	private static final long serialVersionUID = 1L;
	public TooManyAssignmentsException(int i){
		super("Too many assignments!--tried "+i+" assignments!");
	}
}
class NotFoundException extends Exception{
	private static final long serialVersionUID = 1L;
	public NotFoundException (String s){
		super (s+" not found.");
	}
}