/* This program demonstrates how long it takes to insert into a hash table all
 * whitespace-separated strings read from standard input.
 *
 * Usage:  java TimeIt <algorithm> <size>
 */

import java.util.Calendar;
import java.util.Scanner;

public class TimeIt
{
    public static void main(String[] argv)
    {
        if (argv.length != 2)
        {
            System.err.println("Usage:  java TimeIt <algorithm> <size>");
            return;
        }

        HashFunc hf;

        // There's a lesson to be learned here.  Look at ShowIt.  How could this
        // project be better structured?
        if (argv[0].equals("trivial"))
        {
            hf = new TrivialHashFunc();
        }
        else if (argv[0].equals("short-sighted"))
        {
            hf = new ShortSightedHashFunc();
        }
        else if (argv[0].equals("big-sigma"))
        {
            hf = new BigSigmaHashFunc();
        }
        else if (argv[0].equals("multiplier"))
        {
            hf = new MultiplierHashFunc();
        }
        else if (argv[0].equals("crypto"))
        {
            hf = new CryptoHashFunc();
        }
        else if (argv[0].equals("java"))
        {
            hf = new JavaHashFunc();
        }
        else
        {
            System.err.println("The specified algorithm is not supported.");
            return;
        }

        HashTable table = new HashTable(hf, Integer.parseInt(argv[1]));
        Scanner sc = new Scanner(System.in);

        double start = Calendar.getInstance().getTimeInMillis();

        while (sc.hasNext())
        {
            String word = sc.next();
            table.add(word);
        }

        double end = Calendar.getInstance().getTimeInMillis();

        System.out.println("time(ms):  " + (end - start));
    }
}
