/* A hash function using cryptographic hashes.
 */

import java.security.MessageDigest;

public class CryptoHashFunc implements HashFunc
{
    public int map(String s)
    {
        MessageDigest sha1;
       
        try
        {
           sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (java.security.NoSuchAlgorithmException e)
        {
            // This should be available everywhere.
            System.err.println("SHA1 algorithm not available.");
            return 0;
        }

        byte[] digest = sha1.digest(s.getBytes());
        int sum = 0;

        for (int i = 0; i < 4; ++i)
        {
            sum += digest[i] * Math.pow(256.0, i);
        }

        return sum;
    }
}
