/* Union-Find data structure for representing disjoint sets */

public class UnionFind {
	
	class UFelement{
		int rank;
		int parent;
		int size;
		
		public UFelement(int s, int p){
			size=s;
			parent=p;
		}
	};

	UFelement[] u;
	int n;
	
	public UnionFind(int m){
		n = m;
		u = new UFelement[n];
		for(int i=0; i<n; i++){
			u[i] = new UFelement(1,i);
		}
	}
	
	public int find(int t){
		if (t != u[t].parent)
			u[t].parent = find(u[t].parent);
		return u[t].parent;
	}
	
	public void link(int x, int y){
		n-=1;
		if (u[x].rank > u[y].rank){
			u[y].parent = x;
			u[x].size += u[y].size;
		}
		else{
			u[x].parent = y;
			u[y].size += u[x].size;
			if(u[x].rank == u[y].rank)
				u[y].rank+=1;
		}
	}
	
	public int size(int t){
		return u[t].size;
	}
	
	public int number(){
		return n;
	}
	
}
