import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;


public class Document {
	
	String title;
	Set<String> words;
	
	
	public Document(File f){
		Scanner sc;
		try {
			sc = new Scanner(f,"UTF-8");
			title = sc.nextLine().trim().toUpperCase();
			words = new HashSet<String>();
			while(sc.hasNext()){
				words.add(sc.next().toLowerCase());
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	public String getTitle() {
		return title;
	}

	public Set<String> getWords() {
		return words;
	}

}
