package cs2110.netID.phylogeny.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet; 
import java.util.Set;

import cs2110.netID.phylogeny.*;

public class Main {

	public static void main(String[] args) {
		Species rootAnimal = null;
		Set<Species> animals = new HashSet<Species>();
		
		if (args.length < 2) {
			System.err.println("Mode and root must be specified.");
			return;
		}
		
		String mode = args[0].toLowerCase();
		
		// Parse the animals from the .dat file.
		String rootFilename = args[1].substring(args[1].indexOf("=") + 1);
		try {
			for (int i = 2; i < args.length; i++) {
				File file = new File(args[i]);
				Species animal = DatParser.parseAnimal(file);
				animals.add(animal);
				
				// See if we have the root animal.
				String fileName = file.getName();
				fileName = fileName.substring(0, fileName.lastIndexOf("."));
				if (rootFilename.equals(fileName)) {
					rootAnimal = animal;
				}
			}
		}
		catch (IOException e) {
			e.printStackTrace();
			return;
		}
		
		// Check that we have a root animal.
		if (rootAnimal == null) {
			System.err.println(String.format("Couldn't find a file named %s.dat", rootFilename));
			return;
		}
		
		if (mode.equals("--console")) {
			// Generate the phylogenetic tree for this set of animals and the specified root.
			PhylogenyTree tree = new PhylogenyTree(animals, rootAnimal);
			TreePrinter.printPhylogenyTree(tree, System.out);
		}
		else if (mode.equals("--gui")) {
			System.err.println("Gui mode not implemented in A4.");
		}
		else {
			System.err.println("Unknown mode flag: " + mode);
		}
	}

}
