package cs2110.netID.phylogeny.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;

import org.junit.*;

import cs2110.netID.phylogeny.util.*;

public class TreePrinterTests extends PhylogenyTests {
	
	/**
	 * Counts number of tabs at the beginning of a line.
	 * 
	 * @param line - line to check
	 * @return number of tabs at the beginning of the line
	 */
	private int getTabDepth(String line) {
		for (int i = 0; i < line.length(); i++) {
			if (line.charAt(i) != '\t') {
				return i;
			}
		}
		return line.length();
	}
	
	/**
	 * Checks that the output corresponds to a properly structured tree.
	 * 
	 * @param reader - reader from which to read input
	 * @throws IOException
	 */
	private void assertTreeStructure(BufferedReader reader) throws IOException {
		// Check the first line.
		String line = reader.readLine();
		if (line == null) {
			Assert.fail("The tree is empty.");
		}
		int tabs = getTabDepth(line);
		Assert.assertEquals("First line is root, must have 0 tabs.", 0, tabs);
		// Compare each line to the previous in terms of tabs.
		int prev_tabs = tabs;
		while (true) {
			line = reader.readLine();
			if (line == null) {
				break;
			}
			tabs = getTabDepth(line);
			Assert.assertTrue("Only the root can have 0 tabs.", tabs > 0);
			Assert.assertTrue("Each line can have at most 1 more tab than the previous", tabs <= prev_tabs + 1);
			prev_tabs = tabs;
		}
	}
	
	/**
	 * Tests the printed tree for a correct structure.
	 * 
	 * @throws IOException 
	 */
	@Test
	public void testTreeStrucuture() throws IOException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		TreePrinter.printPhylogenyTree(getPhylogenyTree(), new PrintStream(out));
		BufferedReader reader = new BufferedReader(new StringReader(out.toString()));
		assertTreeStructure(reader);
		reader.close();
	}
	
}
