package cs2110.netID.phylogeny.test;

import org.junit.*;

import cs2110.netID.phylogeny.*;

public class SpeciesTests extends PhylogenyTests {
	
	/**
	 * Tests that each animals is its own sibling.
	 */
	@Test
	public void testSiblingReflexive() {
		for (Species animal : animals) {
			String message = "An animal should be its own sibling.";
			Assert.assertTrue(message, animal.isSibling(animal));
		}
	}
	
	/**
	 * Tests that the sibling relation commutes.
	 */
	@Test
	public void testSiblingCommutes() {
		for (Species animal1 : animals) {
			for (Species animal2 : animals) {
				String message = "If animal1 is a sibling of animal2, animal2 should be a sibling of animal1.";
				boolean sibling1 = animal1.isSibling(animal2);
				boolean sibling2 = animal2.isSibling(animal1);
				Assert.assertEquals(message, sibling1, sibling2);
			}
		}
	}
	
	/**
	 * Tests that the animal distance algorithm commutes.
	 */
	@Test
	public void testDistanceCommutes() {
		for (Species animal1 : animals) {
			for (Species animal2 : animals) {
				String message = "Distance from animal1 to animal2 should be the same as from animal2 to animal1.";
				int score1 = animal1.getDistance(animal2);
				int score2 = animal2.getDistance(animal1);
				Assert.assertEquals(message, score1, score2);
			}
		}
	}

}
