package cs2110.netID.phylogeny.test;

import org.junit.*;

import cs2110.netID.phylogeny.*;

public class PhylogenyTreeTests extends PhylogenyTests {
	
	/**
	 * Ensures the tree has the correct number of nodes.
	 * 
	 * @param tree - tree to check
	 * @param size - expected size of tree
	 */
	private void assertTreeSize(PhylogenyTree tree, int size) {
		int count = countNodes(tree);
		Assert.assertEquals(String.format("Tree should have %d nodes.", size), size, count);
	}
	
	/**
	 * Recursively count the number of nodes in the tree.
	 * 
	 * @param tree - tree to check
	 * @return number of nodes in the tree
	 */
	private int countNodes(PhylogenyTree tree) {
		int count = 1;
		for (PhylogenyTree child : tree.getChildren()) {
			count += countNodes(child);
		}
		return count;
	}
	
	/**
	 * Takes the parent of a child node; should give you the same node.
	 * 
	 * @param tree - tree to check
	 */
	private void assertTreeLinks(PhylogenyTree tree) {
		for (PhylogenyTree child : tree.getChildren()) {
			PhylogenyTree me = child.getParent();
			// Child has no parent.
			if (me == null) {
				String parent_name = tree.getAnimal().getName();
				String child_name = child.getAnimal().getName();
				Assert.fail(String.format("Error:  The child of a %s is a %s, who has no parent.", parent_name, child_name));
			}
			// Child has a different parent.
			if (me != tree) {
				String parent_name = tree.getAnimal().getName();
				String child_name = child.getAnimal().getName();
				String parent2_name = child.getParent().getAnimal().getName();
				Assert.fail(String.format("Error:  The child of a %s is a %s, whose parent is a %s.", parent_name, child_name, parent2_name));
			}
			assertTreeLinks(child);
		}
	}
	
	/**
	 * Checks that the tree has the correct number of nodes.
	 */
	@Test
	public void testTreeSize() {
		PhylogenyTree tree = getPhylogenyTree();
		assertTreeSize(tree, NUM_ANIMALS);
	}
	
	/**
	 * Checks that child and parent links agree in the tree.
	 */
	@Test
	public void testTreeLinks() {
		PhylogenyTree tree = getPhylogenyTree();
		assertTreeLinks(tree);
	}
	
	/**
	 * Checks that find on the root animal returns the root.
	 */
	@Test
	public void testFindRoot() {
		Species species = rootAnimal;
		PhylogenyTree tree = getPhylogenyTree();
		Assert.assertNotNull(String.format("Tree should contain %s.", species.getName()), tree.find(species));
		String rootName = tree.find(species).getAnimal().getName();
		String message = String.format("Root of the tree should be %s, but was %s instead.", species.getName(), rootName);
		Assert.assertEquals(message, species.getName(), rootName);
	}

	/**
	 * Test that find on some other animal returns something (instead of null).
	 */
	@Test
	public void testFindInner() {
		// Just arbitrarily pick some animal that should be inside the tree.
		Species species = animals.iterator().next();
		PhylogenyTree tree = getPhylogenyTree();
		Assert.assertNotNull(String.format("Tree should contain %s.", species.getName()), tree.find(species));
	}

}
