// A6PuzzleAsString
// adapted from A1 solution

import java.util.Vector;

public class A6PuzzleAsString {

  private char BLANK='0';     // representation of blank tile (0)
  private int SIZE;           // size of puzzle
  private int END;            // size*size-1 (lastIndex)
  private String solved;      // puzzle in solved state (for quick comparison)

  // Constructor: create a tile size SIZE and set params accordingly:
  public A6PuzzleAsString(int size) {
	  setPuzzleDims(size);
	  setSolved();
  }

  // Set border index values for puzzle:
  private void setPuzzleDims(int size) {
	  SIZE = size;
	  END=size*size-1;
  }
  
  private void setSolved() {
	  // "Fill" puzzle with ascending numbers starting from 1.
	  // Work from left-to-right, then top-down:
	  solved="";
	  for (int c=1; c <= END; c++)
	    solved += c;
    solved +=(""+BLANK);
  }

  // Return true if puzzle is solved:
  public boolean isSolved(SearchNode node) {
	  return node.getPuzzle().equals(solved);
  }

  // generate a vector of possible moves from n
  public Vector generateMoves(SearchNode node) {
	    
	  Vector moves = new Vector();
	  String puzzle = node.getPuzzle();
	  int blankPos = node.getBlankLocation();
	  char[] tiles;

    // North
    if (!((blankPos > END-SIZE) && (blankPos <= END))) {
      // Swap the blank and what's right below it
	    tiles = puzzle.toCharArray();
	    tiles[blankPos]=puzzle.charAt(blankPos+SIZE);
	    tiles[blankPos+SIZE]=BLANK;
      moves.add(new SearchNode(new String(tiles), "SOUTH", node, blankPos+SIZE));
    }
    // East
	  if (!((blankPos - SIZE) % SIZE==0)) {
      // Swap the blank and what's to the left of it
	    tiles = puzzle.toCharArray();
	    tiles[blankPos]=puzzle.charAt(blankPos-1);
	    tiles[blankPos-1]=BLANK;
	    moves.add(new SearchNode(new String(tiles), "WEST", node, blankPos-1));
    }
    // South
    if (!(blankPos < SIZE)) {
      // Swap the blank and what's right above it
	    tiles = puzzle.toCharArray();
	    tiles[blankPos]=puzzle.charAt(blankPos-SIZE);
	    tiles[blankPos-SIZE]=BLANK;
	    moves.add(new SearchNode(new String(tiles), "NORTH", node, blankPos-SIZE));
    }
    // West
	  if (!((blankPos+1) % SIZE==0 )) {
	    // Swap the blank and what's to the right of it
	    tiles = puzzle.toCharArray();
	    tiles[blankPos]=puzzle.charAt(blankPos+1);
	    tiles[blankPos+1]=BLANK;
	    moves.add(new SearchNode(new String(tiles), "EAST", node, blankPos+1));
    }
      
    return moves;
    
  }
    
} // Class A6PuzzleAsString
