/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XClientMessageEvent;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    long imageHandle;
    long tooltipsHandle;
    ImageList imageList;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        this.createWidget(tray.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.parent.createItem(this, n);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.handle = OS.gtk_plug_new(0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.handle, this.imageHandle);
        OS.gtk_widget_show(this.handle);
        OS.gtk_widget_show(this.imageHandle);
        long l = OS.gtk_plug_get_id(this.handle);
        int n2 = 0;
        long l2 = OS.gdk_screen_get_default();
        if (l2 != 0L) {
            n2 = OS.gdk_screen_get_number(l2);
        }
        byte[] byArray = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_S" + n2, true);
        long l3 = OS.gdk_atom_intern(byArray, true);
        long l4 = OS.gdk_x11_atom_to_xatom(l3);
        long l5 = OS.GDK_DISPLAY();
        long l6 = OS.XGetSelectionOwner(l5, l4);
        byte[] byArray2 = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_OPCODE", true);
        long l7 = OS.gdk_atom_intern(byArray2, true);
        long l8 = OS.gdk_x11_atom_to_xatom(l7);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.type = 33;
        xClientMessageEvent.window = l6;
        xClientMessageEvent.message_type = l8;
        xClientMessageEvent.format = 32;
        xClientMessageEvent.data[0] = 0L;
        xClientMessageEvent.data[1] = 0L;
        xClientMessageEvent.data[2] = l;
        long l9 = OS.g_malloc(XClientMessageEvent.sizeof);
        OS.memmove(l9, xClientMessageEvent, (long)XClientMessageEvent.sizeof);
        OS.XSendEvent(l5, l6, false, 0L, l9);
        OS.g_free(l9);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.type == 6) {
            return 0L;
        }
        if (gdkEventButton.button == 3 && gdkEventButton.type == 4) {
            this.sendEvent(35);
            return 0L;
        }
        if (gdkEventButton.type == 5) {
            this.postEvent(14);
        } else {
            this.postEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        if (this.image != null && this.image.mask != 0L && OS.gdk_drawable_get_depth(this.image.mask) == 1) {
            int n = (int)Math.floor((double)OS.GTK_WIDGET_X(l) + (double)(OS.GTK_WIDGET_WIDTH(l) - OS.GTK_WIDGET_REQUISITION_WIDTH(l)) * 0.5 + 0.5);
            int n2 = (int)Math.floor((double)OS.GTK_WIDGET_Y(l) + (double)(OS.GTK_WIDGET_HEIGHT(l) - OS.GTK_WIDGET_REQUISITION_HEIGHT(l)) * 0.5 + 0.5);
            Rectangle rectangle = this.image.getBounds();
            long l3 = OS.gdk_drawable_get_image(this.image.mask, 0, 0, rectangle.width, rectangle.height);
            if (l3 == 0L) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, l3);
            byte[] byArray = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray, gdkImage.mem, (long)byArray.length);
            OS.g_object_unref(l3);
            Region region = new Region(this.display);
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < rectangle.width; ++j) {
                    int n3 = i * gdkImage.bpl + (j >> 3);
                    int n4 = byArray[n3] & 0xFF;
                    int n5 = 1 << (j & 7);
                    if ((n4 & n5) == 0) continue;
                    region.add(n + j, n2 + i, 1, 1);
                }
            }
            OS.gtk_widget_realize(this.handle);
            long l4 = OS.GTK_WIDGET_WINDOW(this.handle);
            OS.gdk_window_shape_combine_region(l4, region.handle, 0, 0);
            region.dispose();
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        int n = 256;
        OS.gtk_widget_add_events(this.handle, n);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.imageHandle, this.display.signalIds[47], 0, this.display.closures[47], false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.gtk_widget_destroy(this.handle);
        }
        this.imageHandle = 0L;
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int n;
            Rectangle rectangle = image.getBounds();
            OS.gtk_widget_set_size_request(this.handle, rectangle.width, rectangle.height);
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((n = this.imageList.indexOf(image)) == -1) {
                n = this.imageList.add(image);
            } else {
                this.imageList.put(n, image);
            }
            long l = this.imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, l);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0L) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.tooltipsHandle);
            OS.gtk_object_sink(this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip(this.tooltipsHandle, this.handle, byArray, null);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.GTK_WIDGET_VISIBLE(this.handle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show(this.handle);
        } else {
            OS.gtk_widget_hide(this.handle);
            this.sendEvent(23);
        }
    }
}

