/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        long l = theme.treeHandle;
        long l2 = OS.gtk_widget_get_style(l);
        long l3 = gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        int n = this.getStateType(0);
        int n2 = 0;
        if ((this.style & 0x400) != 0) {
            n2 = 3;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "treeview", true);
        int n3 = theme.getWidgetProperty(l, "expander-size");
        int n4 = rectangle.x + n3 / 2;
        int n5 = rectangle.y + n3 / 2;
        OS.gtk_paint_expander(l2, l3, n, null, l, byArray, n4, n5, n2);
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        long l = theme.treeHandle;
        int n = theme.getWidgetProperty(l, "expander-size");
        if (new Rectangle(rectangle.x, rectangle.y, n, n).contains(point)) {
            return 0;
        }
        return -1;
    }
}

