/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.test;

import cs2110.assignment2.solution.Gene;
import cs2110.assignment2.solution.Species;
import cs2110.assignment3.test.MissingSourceException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Util {
    static Random rand = new Random(12345L);

    public static <T> List<T> filter(Iterable<T> list, Filter<T> filter) {
        LinkedList<T> result = new LinkedList<T>();
        for (T t : list) {
            if (!filter.accept(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static String randomGene(int minLength, int maxLength) {
        int length = minLength == maxLength ? minLength : rand.nextInt(maxLength - minLength) + minLength + 1;
        StringBuffer dna = new StringBuffer(length);
        char[] nucleotides = new char[]{'A', 'I', 'O', 'C'};
        int prev1 = 0;
        int prev2 = 0;
        int i = 0;
        while (i < length) {
            int c = nucleotides[rand.nextInt(4)];
            if (i >= 2 && c == 65 && prev1 == 73 && prev2 == 67) {
                c = 79;
            }
            dna.append((char)c);
            prev1 = prev2;
            prev2 = c;
            ++i;
        }
        return dna.toString();
    }

    public static ArrayList<String> randomGeneSet(int n, int minLength, int maxLength) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < n) {
            result.add(Util.randomGene(minLength, maxLength));
            ++i;
        }
        return result;
    }

    public static List<String> loadGenes(File[] files) {
        TreeSet geneSet = new TreeSet();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Species s = null;
            try {
                s = new Species(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (s.genome != null) {
                geneSet.addAll(s.genome);
            }
            ++n2;
        }
        LinkedList<String> l = new LinkedList<String>();
        for (Gene g : geneSet) {
            l.add(g.data);
        }
        return l;
    }

    public static Method getGeneDistance(Class<?> obj) {
        String[] methodNames;
        String[] stringArray = methodNames = new String[]{"geneDistance", "GeneDistance", "gene_distance"};
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                return obj.getMethod(name, String.class, String.class);
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return null;
    }

    public static void checkSources(JarFile jf) throws MissingSourceException {
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry classEntry = entries.nextElement();
            String className = classEntry.getName();
            if (!className.endsWith(".class") || className.contains("$")) continue;
            System.out.printf("Checking jar class entry %s.\n", className);
            String sourceName = String.valueOf(className.substring(0, className.lastIndexOf("."))) + ".java";
            JarEntry sourceEntry = jf.getJarEntry(sourceName);
            if (sourceEntry != null) continue;
            throw new MissingSourceException(className);
        }
    }

    public static String readFileToString(File textOutput) throws IOException {
        int bytesRead;
        StringBuffer buffer = new StringBuffer();
        FileReader reader = new FileReader(textOutput);
        char[] data = new char[1024];
        while ((bytesRead = reader.read(data, 0, 1024)) != -1) {
            buffer.append(data, 0, bytesRead);
        }
        return buffer.toString();
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

