/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.test;

public class Problem
implements Runnable {
    public static final int TIMEOUT = 15000;
    public int timeout = 15000;
    public static final boolean grading_mode = false;
    public static final boolean verbose = false;
    protected String name;
    protected int points = 0;
    protected int maxPoints = 0;
    protected Problem[] subProblems = new Problem[0];
    protected Status status = Status.SKIP;
    protected StringBuilder message = new StringBuilder();
    public boolean subtractive = false;

    public Problem(String name, int maxPoints) {
        this.name = name;
        this.maxPoints = maxPoints;
    }

    public Problem(String name) {
        this.name = name;
    }

    public Problem(String name, Problem[] subProblems) {
        this.name = name;
        this.setSubProblems(subProblems);
    }

    public void setSubProblems(Problem[] subProblems) {
        this.subProblems = new Problem[0];
        this.maxPoints = 0;
        this.addSubProblems(subProblems);
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public void registerSubProblem(Problem p) {
        if (this.subtractive) {
            p.setSubtractive();
        }
        p.timeout = this.getTimeout();
    }

    public void addSubProblems(Problem[] subs) {
        Problem[] problemArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Problem sub = problemArray[n2];
            this.maxPoints += sub.getMaxPoints();
            this.registerSubProblem(sub);
            ++n2;
        }
        Problem[] temp = new Problem[subs.length + this.subProblems.length];
        int i = 0;
        i = 0;
        while (i < this.subProblems.length) {
            temp[i] = this.subProblems[i];
            ++i;
        }
        i = 0;
        while (i < subs.length) {
            temp[this.subProblems.length + i] = subs[i];
            ++i;
        }
        this.subProblems = temp;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toStringBuilder(buffer, "");
        return buffer.toString();
    }

    public String getScore() {
        if (!this.subtractive) {
            return String.format("%d/%d", this.points, this.getMaxPoints());
        }
        if (this.getMaxPoints() == this.getPoints()) {
            return "N/A";
        }
        return String.format("-%d", this.getMaxPoints() - this.getPoints());
    }

    public void setSubtractive() {
        this.subtractive = true;
        Problem[] problemArray = this.subProblems;
        int n = this.subProblems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem p = problemArray[n2];
            p.setSubtractive();
            ++n2;
        }
    }

    public String getStatusLine(String indent) {
        return String.format("[%s] %s\n", new Object[]{this.getStatus() == Status.SKIP ? Status.FAIL : this.getStatus(), this.name});
    }

    private boolean isLeaf() {
        return this.subProblems.length == 0;
    }

    public void toStringBuilder(StringBuilder buffer, String indent) {
        if (this.subtractive && this.getMaxPoints() == this.getPoints()) {
            return;
        }
        if (this.isLeaf()) {
            buffer.append(this.getStatusLine(indent));
        }
        if (this.message != null) {
            String[] stringArray = this.message.toString().split("\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.equals("")) {
                    buffer.append(String.valueOf(indent) + "        " + line + "\n");
                }
                ++n2;
            }
        }
        this.subsToStringBuilder(buffer, indent);
    }

    public void subsToStringBuilder(StringBuilder buffer, String indent) {
        Problem[] problemArray = this.subProblems;
        int n = this.subProblems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem sub = problemArray[n2];
            sub.toStringBuilder(buffer, String.valueOf(indent) + "    ");
            ++n2;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void fail() {
        this.status = Status.FAIL;
    }

    public void fail(String msg) {
        this.message.append(String.valueOf(msg) + "\n");
        this.fail();
    }

    public boolean skip() {
        return false;
    }

    public void fail(Exception e) {
        this.fail(e.getMessage());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void preRun() {
        this.points = 0;
    }

    public void postRun() {
        Problem[] problemArray = this.subProblems;
        int n = this.subProblems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem p = problemArray[n2];
            this.points += p.getPoints();
            ++n2;
        }
        this.status = this.points > 0 ? Status.OK : Status.FAIL;
    }

    public int getPoints() {
        return this.points;
    }

    @Override
    public void run() {
        this.preRun();
        Problem[] problemArray = this.subProblems;
        int n = this.subProblems.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Problem sub = problemArray[n2];
                if (!sub.skip()) {
                    try {
                        if (sub.subProblems.length == 0) {
                            int timeout = sub.getTimeout();
                            Thread t = new Thread(sub);
                            t.setDaemon(true);
                            t.start();
                            t.join(timeout);
                            if (t.isAlive()) {
                                t.interrupt();
                                sub.message.append("Test timed out after " + timeout / 1000 + "  seconds\n");
                                break block6;
                            }
                            if (sub.status != Status.SKIP) break block6;
                            sub.ok();
                            break block6;
                        }
                        sub.run();
                    }
                    catch (Exception e) {
                        sub.fail();
                        this.points += sub.points;
                        sub.message.append(String.valueOf(e.getMessage()) + "\n");
                        break;
                    }
                }
            }
            ++n2;
        }
        this.postRun();
    }

    public boolean everythingIsOk() {
        if (this.status != Status.OK) {
            return false;
        }
        Problem[] problemArray = this.subProblems;
        int n = this.subProblems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem p = problemArray[n2];
            if (!p.everythingIsOk()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void ok() {
        if (this.points == 0) {
            this.points = this.maxPoints;
        }
        this.status = Status.OK;
    }

    public void failIf(boolean condition) {
        if (condition) {
            this.fail();
        } else {
            this.ok();
        }
    }

    public void failUnless(boolean condition) {
        this.failIf(!condition);
    }

    public static enum Status {
        OK,
        SKIP,
        FAIL;

    }
}

