/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.test;

import cs2110.assignment3.test.GeneComparator;
import cs2110.assignment3.test.Species;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;

class OutputParser {
    public List<String> genes;
    public int[][] geneComparisonMatrix;
    public List<Species> species;
    public int[][] speciesComparisonMatrix;
    public Exception thrownException = null;
    private static final Pattern NUMBER_LINE = Pattern.compile("^\\s*\\d[01234567890 \\t]*$", 8);
    private static final Pattern GENE_HEADER = Pattern.compile("^\\s*G(\\d+)\\s*[=:]\\s*([ACIO]+)\\s*", 10);
    private static final Pattern ANIMAL_HEADER = Pattern.compile("^\\s*A(\\d+)\\s*[=:]\\s*(\\S.*?)\\s*[:=]?\\s*(Genes)?[:=]?\\s*[\\[{\\(]\\s*(Genes)?[:]?\\s*([01234567890 \\t]*)[\\]}\\)]\\s*", 10);
    private static final Pattern COMMENT = Pattern.compile("(\\||//).*$", 8);
    private static final Pattern BLANK = Pattern.compile("^\\s*$", 8);
    private Scanner scanner;
    private int lineno = 1;
    PrintStream out;

    public String getCurrentLine() {
        try {
            return this.scanner.next();
        }
        catch (NoSuchElementException e) {
            return "EOF";
        }
    }

    public OutputParser(String output, Exception thrownException) {
        this.thrownException = thrownException;
        output = COMMENT.matcher(output).replaceAll("");
        output = output.replace(",", " ");
        this.scanner = new Scanner(output);
        this.scanner.useDelimiter("\\r\\n|\\n");
    }

    private void skipBlankLines() {
        while (this.scanner.hasNext(BLANK)) {
            this.next();
        }
    }

    private String next() {
        String s = this.scanner.next();
        if (this.out != null) {
            this.out.printf("Line %d: %s\n", this.lineno, this.trunc(s));
        }
        ++this.lineno;
        return s;
    }

    private String next(Pattern p) {
        ++this.lineno;
        String s = this.scanner.next(p);
        if (this.out != null) {
            this.out.printf("Line %d: %s\n", this.lineno, this.trunc(s));
        }
        return s;
    }

    public String trunc(String s) {
        int LIMIT = 100;
        if (s.length() > 100) {
            return String.valueOf(s.substring(0, 100)) + "...";
        }
        return s;
    }

    public void parse() throws FormatError {
        this.skipBlankLines();
        if (this.scanner.hasNext(GENE_HEADER)) {
            this.parseGenes();
        } else if (this.scanner.hasNext(ANIMAL_HEADER)) {
            this.parseAnimals();
        } else {
            throw new FormatError("Expected either a gene or animal header, e.g.,  G0=... or A0=...");
        }
    }

    private void parseAnimals() throws FormatError {
        int i;
        this.next(ANIMAL_HEADER);
        if (this.species == null) {
            this.species = new ArrayList<Species>();
        }
        if ((i = Integer.parseInt(this.scanner.match().group(1))) != this.species.size()) {
            throw new FormatError(String.format("Animal %d is out-of-order", i));
        }
        String name = this.scanner.match().group(2);
        String genestr = this.scanner.match().group(5);
        Scanner s = new Scanner(genestr);
        LinkedList<Integer> agenes = new LinkedList<Integer>();
        try {
            agenes.add(s.nextInt());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.species.add(new Species(name, agenes));
        this.skipBlankLines();
        if (this.scanner.hasNext(ANIMAL_HEADER)) {
            this.parseAnimals();
        } else {
            int n = this.species.size();
            this.speciesComparisonMatrix = new int[n][n];
            this.parseMatrix("A", this.speciesComparisonMatrix);
        }
        this.parseEOF();
    }

    private void parseEOF() throws FormatError {
        this.skipBlankLines();
        try {
            this.scanner.next();
            throw new FormatError("Expected end-of-file");
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void parseGenes() throws FormatError {
        int i;
        this.next(GENE_HEADER);
        if (this.genes == null) {
            this.genes = new ArrayList<String>();
        }
        if ((i = Integer.parseInt(this.scanner.match().group(1))) != this.genes.size()) {
            throw new FormatError(String.format("Gene number %d is out of order", i));
        }
        String gene = this.scanner.match().group(2);
        this.genes.add(gene);
        if (i > 0 && new GeneComparator().compare(gene, this.genes.get(i - 1)) == -1) {
            throw new FormatError(String.format("G%d precedes G%d in the gene sort order", i, i - 1));
        }
        this.skipBlankLines();
        if (this.scanner.hasNext(GENE_HEADER)) {
            this.parseGenes();
            return;
        }
        int n = this.genes.size();
        this.geneComparisonMatrix = new int[n][n];
        this.parseMatrix("G", this.geneComparisonMatrix);
        this.skipBlankLines();
        if (!this.scanner.hasNext(ANIMAL_HEADER)) {
            throw new FormatError("Expected animal header A0=...");
        }
        this.parseAnimals();
    }

    private void parseMatrix(String headerChar, int[][] matrix) throws FormatError {
        String line;
        this.skipBlankLines();
        try {
            line = this.next();
        }
        catch (NoSuchElementException nse) {
            throw new FormatError(String.format("Expected matrix header, e.g., %s0 %s1 %s2 ...", headerChar, headerChar, headerChar));
        }
        Scanner s = new Scanner(line);
        int i = 0;
        try {
            while (true) {
                String h = String.valueOf(headerChar) + new Integer(i).toString();
                s.next(h);
                ++i;
            }
        }
        catch (NoSuchElementException nse) {
            if (i != matrix.length) {
                throw new FormatError(String.format("Malformed matrix header: Should have exactly %d column headers, starting with %s0", matrix.length, headerChar), false);
            }
            i = 0;
            try {
                while (true) {
                    this.skipBlankLines();
                    String row = this.next(NUMBER_LINE);
                    s = new Scanner(row);
                    int j = 0;
                    try {
                        while (true) {
                            try {
                                matrix[i][j] = s.nextInt();
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            ++j;
                        }
                    }
                    catch (NoSuchElementException nse2) {
                        if (j != matrix.length) {
                            throw new FormatError(String.format("Malformed row: Should have exactly %d elements", matrix.length), false);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchElementException nse3) {
                if (i != matrix.length) {
                    throw new FormatError(String.format("Malformed matrix: Should have exactly %d rows", matrix.length));
                }
                return;
            }
        }
    }

    public class FormatError
    extends Exception {
        private String msg;

        public FormatError(String msg) {
            this.msg = String.format("Syntax error on input line %d: %s\n>>> %s\n", OutputParser.this.lineno, msg, OutputParser.this.getCurrentLine());
        }

        public FormatError(String msg, boolean showline) {
            this.msg = String.format("Syntax error on input line %d: %s\n", OutputParser.this.lineno, msg);
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }
}

