/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.test;

import cs2110.assignment3.test.JarFileLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarInspector {
    private String filename;

    public JarInspector(String filename) throws ZipException, IOException {
        this.filename = filename;
    }

    public String getSourceName(Class<?> klass) {
        String classname = klass.getName();
        String sourcename = String.valueOf(classname.substring(classname.lastIndexOf(46) + 1, classname.length())) + ".java";
        return sourcename;
    }

    public byte[] getSource(Class<?> klass) throws ZipException, IOException {
        ZipFile zf = new ZipFile(this.filename);
        String classname = klass.getName();
        String sourcename = String.valueOf(classname.replace('.', '/')) + ".java";
        ZipEntry sourceEntry = zf.getEntry(sourcename);
        if (sourceEntry == null) {
            return null;
        }
        byte[] data = this.readEntry(zf, sourceEntry);
        return data;
    }

    private byte[] readEntry(ZipFile zf, ZipEntry z) throws IOException {
        int len = (int)z.getSize();
        int offset = 0;
        byte[] data = new byte[len];
        InputStream is = zf.getInputStream(z);
        while (len > 0) {
            long bytesRead = is.read(data, offset, len);
            len = (int)((long)len - bytesRead);
            offset = (int)((long)offset + bytesRead);
        }
        is.close();
        return data;
    }

    public LinkedList<Class<?>> findClasses() throws ZipException, IOException {
        ZipFile zf = new ZipFile(this.filename);
        Enumeration<? extends ZipEntry> en = zf.entries();
        LinkedList results = new LinkedList();
        while (en.hasMoreElements()) {
            ZipEntry z = en.nextElement();
            if (!z.getName().endsWith(".class")) continue;
            String classname = z.getName().substring(0, z.getName().indexOf(46));
            classname = classname.replace("/", ".");
            this.filename = new File(this.filename).getAbsolutePath();
            URL[] urls = new URL[]{};
            JarFileLoader cl = new JarFileLoader(urls);
            cl.addFile(this.filename);
            Class<?> k = null;
            try {
                k = cl.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
            results.add(k);
        }
        zf.close();
        return results;
    }

    public LinkedList<Class<?>> findClassesImplementing(String interfaceName) throws ZipException, IOException {
        LinkedList results = new LinkedList();
        block0: for (Class clazz : this.findClasses()) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (i.getName().equals(interfaceName)) {
                    results.add(clazz);
                    continue block0;
                }
                ++n2;
            }
        }
        return results;
    }

    static class ByteClassLoader
    extends ClassLoader {
        ByteClassLoader() {
        }

        public Class<?> classFromBytes(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

