/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.test;

import cs2110.assignment3.test.FormatException;
import cs2110.assignment3.test.JarClassLoader;
import cs2110.assignment3.test.JarInspector;
import cs2110.assignment3.test.MainNotStaticException;
import cs2110.assignment3.test.MissingSourceException;
import cs2110.assignment3.test.OutputParser;
import cs2110.assignment3.test.Problem;
import cs2110.assignment3.test.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarFile;

public class A3ComplianceTool
extends Problem {
    private Method mainMethod;
    private StringBuilder outputBuffer = new StringBuilder();
    private File animalDataDirectory;
    private File jarFile;

    public A3ComplianceTool(File jar, File animalDataDirectory) {
        super("Assignment 3 Formatting Test", new Problem[0]);
        this.animalDataDirectory = animalDataDirectory;
        this.jarFile = jar;
        this.setSubProblems(new Problem[]{new Problem("Contains source code"){

            @Override
            public void run() {
                JarFile jf = null;
                try {
                    jf = new JarFile(A3ComplianceTool.this.jarFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.printf("Error reading JAR file: " + e.getMessage(), new Object[0]);
                    System.exit(1);
                }
                try {
                    Util.checkSources(jf);
                }
                catch (MissingSourceException e) {
                    this.fail(e);
                }
            }
        }, new Problem("Has main method", 1){

            @Override
            public void run() {
                String mainClassName = A3ComplianceTool.this.getMainClassName();
                JarInspector j = null;
                try {
                    j = new JarInspector(A3ComplianceTool.this.jarFile.getPath());
                }
                catch (Exception e) {
                    this.fail(e);
                    return;
                }
                try {
                    List<Class<?>> matchingClasses = Util.filter(j.findClasses(), new Util.Filter<Class<?>>(){

                        @Override
                        public boolean accept(Class<?> obj) {
                            try {
                                obj.getMethod("main", String[].class);
                            }
                            catch (Exception e) {
                                return false;
                            }
                            return true;
                        }
                    });
                    class MainClassComparator
                    implements Comparator<Class<?>> {
                        private final /* synthetic */ String val$mainClassName;

                        MainClassComparator(String string) {
                            this.val$mainClassName = string;
                        }

                        public Integer confidence(Class<?> arg0) {
                            return (arg0.getName().equals(this.val$mainClassName) ? 3 : 0) + (arg0.getSuperclass().getName().endsWith("ComparisonGUI") ? 1 : 0) + (arg0.getName().endsWith("ComparisonGUI") ? 1 : 0);
                        }

                        @Override
                        public int compare(Class<?> arg0, Class<?> arg1) {
                            return this.confidence(arg1).compareTo(this.confidence(arg0));
                        }
                    }
                    MainClassComparator comparator = new MainClassComparator(mainClassName);
                    Collections.sort(matchingClasses, comparator);
                    if (matchingClasses.size() == 0) {
                        this.fail();
                        return;
                    }
                    Class<?> match = matchingClasses.get(0);
                    this.message.append("Containing class: " + match.getName());
                    A3ComplianceTool.this.mainMethod = match.getMethod("main", String[].class);
                    A3ComplianceTool.this.mainMethod.setAccessible(true);
                }
                catch (Exception e) {
                    this.fail(e);
                    return;
                }
                this.ok();
            }
        }, new OutputFormattingTest("Console Output Format", 1, animalDataDirectory.getAbsolutePath())});
    }

    public A3ComplianceTool(File textOutput) {
        super("Assignment 3 Output Formatting Test", new Problem[0]);
        String output;
        try {
            output = Util.readFileToString(textOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Error reading " + textOutput.getPath() + ": " + e.getMessage());
            return;
        }
        final String finalOutput = output;
        this.setSubProblems(new Problem[]{new Problem("Test Output Format", 1){

            @Override
            public void run() {
                try {
                    OutputParser parser = new OutputParser(finalOutput, null);
                    parser.out = System.out;
                    parser.parse();
                }
                catch (OutputParser.FormatError er) {
                    this.fail(er);
                }
            }
        }});
    }

    public String getMainClassName() {
        JarClassLoader jcl;
        try {
            jcl = new JarClassLoader(this.jarFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error with grading program: " + e.getMessage());
        }
        try {
            return jcl.getMainClassName();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error with grading program: " + ioe.getClass().getName() + ioe.getMessage());
        }
    }

    public OutputParser runMain(String[] args) throws MainNotStaticException {
        ByteArrayOutputStream redirect;
        Exception x;
        block10: {
            x = null;
            PrintStream oldOut = System.out;
            redirect = new ByteArrayOutputStream();
            System.setOut(new PrintStream(redirect));
            try {
                this.mainMethod.invoke(null, new Object[]{args});
            }
            catch (NullPointerException e) {
                throw new MainNotStaticException();
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Shouldn't happen:" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                x = e;
                System.setOut(oldOut);
                break block10;
            }
            catch (InvocationTargetException e) {
                try {
                    x = e;
                    int i = 0;
                    while (x instanceof InvocationTargetException) {
                        if (i++ > 1 || !(x.getCause() instanceof Exception)) break;
                        x = (Exception)x.getCause();
                    }
                    x.printStackTrace();
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    System.setOut(oldOut);
                }
            }
            System.setOut(oldOut);
        }
        return new OutputParser(redirect.toString(), x);
    }

    public static void main(String[] args) throws IOException, FormatException {
        if (args.length != 2) {
            System.err.println("You must provide a jar file path and the path to an A3 animal data directory, or the -output flag and the path to a text file containing your program's output");
        }
        if (args[0].equals("-output")) {
            A3ComplianceTool.mainOutputTest(new File(args[1]));
            return;
        }
        File jarFile = new File(args[0]);
        File animalDataDirectory = new File(args[1]);
        A3ComplianceTool.mainJarTest(jarFile, animalDataDirectory);
    }

    public static void mainOutputTest(File outputFile) {
        if (!outputFile.exists()) {
            System.err.println("File not found: " + outputFile.getPath());
            return;
        }
        A3ComplianceTool.printDisclaimer();
        System.out.printf("Testing formatting for \"%s\"...\n", outputFile);
        A3ComplianceTool grader = new A3ComplianceTool(outputFile);
        grader.run();
        System.out.println(grader);
        if (!grader.everythingIsOk()) {
            System.out.println("\n\nErrors were reported.  Please correct them before submitting your assignment.\n\n");
        }
        A3ComplianceTool.printDisclaimer();
    }

    public static void mainJarTest(File jarFile, File animalDataDirectory) {
        if (!jarFile.exists()) {
            System.err.println("File not found: " + jarFile.getPath());
            return;
        }
        if (!animalDataDirectory.exists()) {
            System.err.println("Directory not found: " + animalDataDirectory.getPath());
            return;
        }
        A3ComplianceTool.printDisclaimer();
        System.out.printf("Testing formatting for \"%s\"...\n", jarFile);
        A3ComplianceTool grader = new A3ComplianceTool(jarFile, animalDataDirectory);
        grader.run();
        System.out.println(grader);
        if (!grader.everythingIsOk()) {
            System.out.println("\n\nErrors were reported.  Please correct them before submitting your assignment.\n\n");
        }
        A3ComplianceTool.printDisclaimer();
    }

    @Override
    public String toString() {
        return "\n-----------------------------------------------------\n" + super.toString();
    }

    private static void printDisclaimer() {
        System.err.println("Important!   This tester only checks your console-mode output formatting.  It does NOT check the correctness of your animal-to-animal comparisons!");
    }

    static class ByteClassLoader
    extends ClassLoader {
        ByteClassLoader() {
        }

        public Class<?> classFromBytes(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }

    public class OutputFormattingTest
    extends Problem {
        private OutputParser output;

        @Override
        public boolean skip() {
            return A3ComplianceTool.this.mainMethod == null;
        }

        public OutputFormattingTest(String name, int maxPoints, final String directory) {
            super(name, maxPoints);
            this.timeout = 300000;
            this.setSubProblems(new Problem[]{new Problem("Run Main", 2){

                @Override
                public void run() {
                    try {
                        OutputFormattingTest.this.output = A3ComplianceTool.this.runMain(new String[]{"console", directory});
                    }
                    catch (MainNotStaticException e) {
                        OutputFormattingTest.this.output = new OutputParser("", e);
                        this.fail("Main is not static; cannot call!");
                        return;
                    }
                    if (((OutputFormattingTest)OutputFormattingTest.this).output.thrownException != null) {
                        this.fail(String.format("Main threw exception of type %s: %s\n", ((OutputFormattingTest)OutputFormattingTest.this).output.thrownException.getClass().getName(), ((OutputFormattingTest)OutputFormattingTest.this).output.thrownException));
                        ((OutputFormattingTest)OutputFormattingTest.this).output.thrownException.printStackTrace();
                    }
                }
            }, new Problem("Output Formatting"){

                @Override
                public void run() {
                    ((OutputFormattingTest)OutputFormattingTest.this).output.out = System.out;
                    try {
                        OutputFormattingTest.this.output.parse();
                    }
                    catch (OutputParser.FormatError se) {
                        this.fail(se);
                        se.printStackTrace();
                    }
                }
            }});
        }
    }
}

