/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swt;

import cs2110.assignment3.swt.Cell;
import cs2110.assignment3.swt.ColorThread;
import cs2110.assignment3.swt.InvalidCellNumberException;
import cs2110.assignment3.swt.InvalidColorException;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ComparisonGUI {
    private Cell[] cells;
    private HashMap<Cell, Integer> cellmap;
    private Shell shell;
    private Display display = new Display();
    private int rows;
    private int columns = 7;
    private int n;
    private Label bigLabel1;
    private Label bigLabel2;
    private Label bigImage1;
    private Label bigImage2;
    protected static final int CELL_WIDTH = 90;
    protected static final int CELL_HEIGHT = 90;
    private Canvas canvas;
    private ColorThread colorthread;

    public ComparisonGUI(int n) {
        this.cellmap = new HashMap();
        this.rows = (int)Math.ceil((double)n / (double)this.columns);
        this.shell = new Shell(this.display);
        this.shell.setText("Species Comparison (beta)");
        this.shell.open();
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        this.shell.setLayout(layout);
        this.createMenu();
        this.canvas = new Canvas(this.shell, 2048);
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        this.canvas.setLayoutData(data1);
        this.createComparisonPanel();
        this.n = this.rows * this.columns;
        this.cells = new Cell[this.n];
        this.canvas.setSize(this.columns * 90, this.rows * 90);
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.columns) {
                Cell cell = new Cell(this, this.canvas);
                Label img = cell.createImage();
                img.setBounds(col * 90, row * 90, 90, 90);
                int index = row * this.columns + col;
                this.cells[index] = cell;
                this.cellmap.put(cell, index);
                ++col;
            }
            ++row;
        }
    }

    private void createMenu() {
        Menu menuBar = new Menu(this.shell, 2);
        MenuItem fileMenuHeader = new MenuItem(menuBar, 64);
        fileMenuHeader.setText("&File");
        Menu fileMenu = new Menu(this.shell, 4);
        fileMenuHeader.setMenu(fileMenu);
        MenuItem fileExitItem = new MenuItem(fileMenu, 8);
        fileExitItem.setText("E&xit");
        fileExitItem.addSelectionListener(new FileExitListener());
        this.shell.setMenuBar(menuBar);
    }

    private void createComparisonPanel() {
        Shell parent = this.shell;
        this.bigLabel1 = new Label(parent, 0);
        this.bigLabel1.setText("Selected: ");
        this.bigLabel1.setVisible(true);
        FormData l1data = new FormData();
        l1data.width = 250;
        l1data.left = new FormAttachment(this.canvas, 10);
        this.bigLabel1.setLayoutData(l1data);
        this.bigImage1 = new Label(parent, 0);
        this.bigImage1.setVisible(true);
        FormData i1data = new FormData();
        i1data.left = new FormAttachment(this.canvas, 10);
        i1data.top = new FormAttachment(this.bigLabel1, 10);
        this.bigImage1.setLayoutData(i1data);
        this.bigLabel2 = new Label(parent, 0);
        this.bigLabel2.setText("Closest relative::");
        this.bigLabel2.setVisible(true);
        FormData l2data = new FormData();
        l2data.width = 250;
        l2data.left = new FormAttachment(this.canvas, 10);
        l2data.top = new FormAttachment(this.bigImage1, 10);
        this.bigLabel2.setLayoutData(l2data);
        this.bigImage2 = new Label(parent, 0);
        this.bigImage2.setVisible(true);
        FormData i2data = new FormData();
        i2data.left = new FormAttachment(this.canvas, 10);
        i2data.top = new FormAttachment(this.bigLabel2, 10);
        this.bigImage2.setLayoutData(i2data);
        ((Control)parent).setVisible(true);
    }

    private Cell getCell(int index) {
        return this.cells[index];
    }

    public void onSelectCell(int cell) {
        System.out.println("onSelectCell: User clicked cell " + cell);
    }

    protected void selectCell(Cell cell) {
        int index = this.cellmap.get(cell);
        this.onSelectCell(index);
    }

    public void setCellImage(int cell, String filename) throws InvalidCellNumberException {
        this.checkCell(cell);
        this.getCell(cell).setImageFile(filename);
    }

    private void checkCell(int cell) throws InvalidCellNumberException {
        if (cell < 0 || cell >= this.n) {
            throw new InvalidCellNumberException();
        }
    }

    public void setCellColor(int cell, double red, double green, double blue) throws InvalidColorException, InvalidCellNumberException {
        this.checkCell(cell);
        if (red < 0.0 || red > 1.0) {
            throw new InvalidColorException();
        }
        if (green < 0.0 || green > 1.0) {
            throw new InvalidColorException();
        }
        if (blue < 0.0 || blue > 1.0) {
            throw new InvalidColorException();
        }
        this.getCell(cell).setColor((int)(red * 255.0), (int)(255.0 * green), (int)(255.0 * blue));
    }

    public void setSelectedInfo(String name, String imageFile) {
        this.bigImage1.setImage(this.loadImage(imageFile));
        this.bigLabel1.setText("Selected: " + name);
    }

    public void setClosestRelativeInfo(String name, String imageFile) {
        this.bigImage2.setImage(this.loadImage(imageFile));
        this.bigLabel2.setText("Closest relative: " + name);
    }

    protected Image loadImage(String filename) {
        return new Image((Device)this.display, filename);
    }

    public void run() {
        this.colorthread = new ColorThread(this.display, this.cells);
        this.shell.pack();
        this.shell.open();
        this.colorthread.start();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.colorthread.running = false;
        try {
            this.colorthread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.display.dispose();
    }

    private class FileExitListener
    implements SelectionListener {
        private FileExitListener() {
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            ComparisonGUI.this.shell.close();
            ComparisonGUI.this.display.dispose();
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

