/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swt;

import cs2110.assignment3.swt.Color;
import cs2110.assignment3.swt.ComparisonGUI;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

class Cell {
    private Label imageLabel;
    private Composite parent;
    private int style = 0x800000;
    private ComparisonGUI app;
    private String imageFile;
    protected Color currentColor;
    protected Color targetColor;
    private static final double COLOR_CHANGE_TIME = 0.2;

    protected Cell(ComparisonGUI app, Composite parent) {
        this.parent = parent;
        this.imageLabel = null;
        this.app = app;
        this.targetColor = this.currentColor = new Color(1, 1, 1);
    }

    protected Label createImage() {
        this.imageLabel = new Label(this.parent, this.style);
        this.imageLabel.setVisible(true);
        this.imageLabel.addMouseListener(new CellMouseListener(this));
        return this.imageLabel;
    }

    protected void setImageFile(String filename) {
        this.imageFile = filename;
        assert (this.imageLabel != null);
        Image image = new Image((Device)this.imageLabel.getDisplay(), this.imageFile);
        Image scaled = new Image((Device)this.imageLabel.getDisplay(), image.getImageData().scaledTo(90, 90));
        this.imageLabel.setVisible(true);
        this.imageLabel.setImage(scaled);
    }

    private void setColorImmediate(Color c) {
        this.currentColor = c;
        this.imageLabel.setBackground(c.toEclipse(this.imageLabel.getDisplay()));
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(new Color(red, green, blue));
    }

    protected void clearColor() {
        this.setColor(null);
    }

    public void setColor(Color c) {
        if (c == null) {
            c = new Color(255, 255, 255);
        }
        this.targetColor = c;
    }

    protected void advanceColor(double dt) {
        if (this.currentColor.equals(this.targetColor)) {
            return;
        }
        this.setColorImmediate(this.currentColor.blend(this.targetColor, dt / 0.2));
    }

    private class CellMouseListener
    implements MouseListener {
        private Cell cell;

        public CellMouseListener(Cell cell2) {
            this.cell = cell2;
        }

        @Override
        public void mouseDown(MouseEvent e) {
            this.cell.app.selectCell(this.cell);
        }

        @Override
        public void mouseUp(MouseEvent e) {
        }

        @Override
        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

