/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swing;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class ScalingImageButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Image image;
    private Image scaledImage;
    private int imageWidth = 0;
    private int imageHeight = 0;

    public ScalingImageButton() {
        this.setOpaque(true);
    }

    public void loadImage(String file) throws IOException {
        this.image = ImageIO.read(new File(file));
        this.imageWidth = this.image.getWidth(this);
        this.imageHeight = this.image.getHeight(this);
        this.setScaledImage();
    }

    public void scaleImage() {
        this.setScaledImage();
    }

    protected void setScaledImage() {
        this.setScaledImage(this.getWidth(), this.getHeight());
    }

    protected void setScaledImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.image != null) {
            float iw = this.imageWidth;
            float ih = this.imageHeight;
            float pw = new Float(width).floatValue();
            float ph = new Float(height).floatValue();
            if (pw == 0.0f || ph == 0.0f || iw == 0.0f || ih == 0.0f) {
                return;
            }
            if (pw / ph >= iw / ih) {
                iw = iw * ph / ih;
                ih = ph;
            } else {
                ih = ih * pw / iw;
                iw = pw;
            }
            this.scaledImage = this.image.getScaledInstance(new Float(iw).intValue(), new Float(ih).intValue(), 1);
            this.setIcon(new ImageIcon(this.scaledImage));
        }
    }
}

