/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swing;

import cs2110.assignment3.swing.Cell;
import cs2110.assignment3.swing.Color;
import cs2110.assignment3.swing.ColorThread;
import cs2110.assignment3.swing.InvalidCellNumberException;
import cs2110.assignment3.swing.InvalidColorException;
import cs2110.assignment3.swing.ScalingImageButton;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ComparisonGUI {
    private int n;
    private int columns = 5;
    private int rows;
    private Cell[] cells;
    private JLabel selectedLabel;
    private JLabel closestRelatedLabel;
    private JLabel selectedImage;
    private JLabel closestRelatedImage;
    protected static final int CELL_WIDTH = 90;
    protected static final int CELL_HEIGHT = 90;
    private JFrame frame;
    private JPanel mainPane;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private ColorThread colorthread;

    public ComparisonGUI(int n) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            throw new RuntimeException("ComparisonGUI constructor must have n >= 0");
        }
        this.n = n;
        this.setup();
    }

    private void setup() {
        int width = 800;
        int height = 500;
        this.frame = new JFrame("Species Comparison Interface");
        this.frame.setDefaultCloseOperation(3);
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        Container topPane = this.frame.getContentPane();
        this.rows = (int)Math.ceil((double)this.n / (double)this.columns);
        topPane.setLayout(new BoxLayout(topPane, 1));
        this.mainPane = new JPanel();
        topPane.add(this.mainPane);
        this.mainPane.setLayout(null);
        this.mainPane.add(this.leftPanel);
        this.mainPane.add(this.rightPanel);
        this.leftPanel.setLayout(new GridLayout(this.rows, this.columns));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.updateManualLayout(800, 500);
        this.createComparisonPanel(this.rightPanel);
        this.cells = new Cell[this.n];
        topPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComparisonGUI.this.updateManualLayout(ComparisonGUI.this.mainPane.getWidth(), ComparisonGUI.this.mainPane.getHeight());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        int i = 0;
        while (i < this.n) {
            final ScalingImageButton imageButton = new ScalingImageButton();
            imageButton.setSize(90, 90);
            this.leftPanel.add(imageButton);
            this.cells[i] = new Cell(imageButton);
            final int index = i++;
            imageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ComparisonGUI.this.onSelectCell(index);
                }
            });
            imageButton.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent arg0) {
                }

                @Override
                public void componentMoved(ComponentEvent arg0) {
                }

                @Override
                public void componentResized(ComponentEvent arg0) {
                    imageButton.setScaledImage(800 / ComparisonGUI.this.columns, 500 / ComparisonGUI.this.rows);
                }

                @Override
                public void componentShown(ComponentEvent arg0) {
                }
            });
        }
        this.frame.setSize(800, 500);
        this.frame.setMinimumSize(new Dimension(800, 500));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void updateManualLayout(int w, int h) {
        int bar = w - 300;
        this.getComparisonPanel().setBounds(bar, 0, bar + 300, h);
        this.getGridPanel().setBounds(0, 0, bar, h);
        this.getComparisonPanel().updateUI();
        this.getGridPanel().updateUI();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JPanel getComparisonPanel() {
        return this.rightPanel;
    }

    public JPanel getGridPanel() {
        return this.leftPanel;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    private void createComparisonPanel(JPanel parent) {
        this.selectedLabel = new JLabel("Selected: ");
        parent.add(this.selectedLabel);
        this.selectedImage = new JLabel();
        parent.add(this.selectedImage);
        this.closestRelatedLabel = new JLabel("Closest relative: ");
        parent.add(this.closestRelatedLabel);
        this.closestRelatedImage = new JLabel();
        parent.add(this.closestRelatedImage);
    }

    private Cell getCell(int index) {
        return this.cells[index];
    }

    public void onSelectCell(int cell) {
        System.out.println("onSelectCell: User clicked cell " + cell);
    }

    public void setCellImage(int cell, String filename) throws InvalidCellNumberException {
        this.checkCell(cell);
        try {
            this.getCell(cell).setImageFile(filename);
        }
        catch (IOException e) {
            System.err.println("Image not found: " + filename);
        }
    }

    private void checkCell(int cell) throws InvalidCellNumberException {
        if (cell < 0 || cell >= this.n) {
            throw new InvalidCellNumberException();
        }
    }

    public void setCellColor(int cell, double red, double green, double blue) throws InvalidColorException, InvalidCellNumberException {
        this.checkCell(cell);
        if (red < 0.0 || red > 1.0) {
            throw new InvalidColorException();
        }
        if (green < 0.0 || green > 1.0) {
            throw new InvalidColorException();
        }
        if (blue < 0.0 || blue > 1.0) {
            throw new InvalidColorException();
        }
        this.getCell(cell).setColor((int)(red * 255.0), (int)(255.0 * green), (int)(255.0 * blue));
    }

    public void setCellColor(int cell, java.awt.Color color) throws InvalidCellNumberException {
        this.checkCell(cell);
        this.getCell(cell).setColor(new Color(color));
    }

    public void setSelectedInfo(String name, String imageFile) {
        this.selectedImage.setIcon(new ImageIcon(imageFile));
        this.selectedLabel.setText("Selected: " + name);
    }

    public void setClosestRelativeInfo(String name, String imageFile) {
        this.closestRelatedImage.setIcon(new ImageIcon(imageFile));
        this.closestRelatedLabel.setText("Closest relative: " + name);
    }

    public void run() {
        this.colorthread = new ColorThread(this.cells);
        this.colorthread.start();
    }
}

