/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swing;

class Color {
    private double r;
    private double g;
    private double b;

    public Color(double red, double green, double blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public Color(int red, int green, int blue) {
        this.r = (double)red / 255.0;
        this.g = (double)green / 255.0;
        this.b = (double)blue / 255.0;
    }

    public Color(java.awt.Color color) {
        this.r = (double)color.getRed() / 255.0;
        this.g = (double)color.getGreen() / 255.0;
        this.b = (double)color.getBlue() / 255.0;
    }

    public boolean equals(Color other) {
        return this.r == other.r && this.g == other.g && this.b == other.b;
    }

    public int getRedInt() {
        return (int)(255.0 * this.r);
    }

    public int getGreenInt() {
        return (int)(255.0 * this.g);
    }

    public int getBlueInt() {
        return (int)(255.0 * this.b);
    }

    protected Color blend(Color other, double d) {
        d = Math.min(1.0, d);
        return new Color(this.r * (1.0 - d) + other.r * d, this.g * (1.0 - d) + other.g * d, this.b * (1.0 - d) + other.b * d);
    }

    public java.awt.Color toAwt() {
        return new java.awt.Color((float)this.r, (float)this.g, (float)this.b);
    }
}

