/*
 * Decompiled with CFR 0.152.
 */
package cs2110.assignment3.swing;

import cs2110.assignment3.swing.Color;
import cs2110.assignment3.swing.ScalingImageButton;
import java.io.IOException;

class Cell {
    protected Color currentColor;
    protected Color targetColor;
    protected ScalingImageButton image;
    private static final double COLOR_CHANGE_TIME = 0.2;

    protected Cell(ScalingImageButton imp) {
        this.image = imp;
        this.targetColor = this.currentColor = new Color(1, 1, 1);
    }

    protected void setImageFile(String filename) throws IOException {
        this.image.loadImage(filename);
    }

    private void setColorImmediate(Color c) {
        this.currentColor = c;
        this.image.setBackground(c.toAwt());
    }

    protected void setColor(int red, int green, int blue) {
        this.setColor(new Color(red, green, blue));
    }

    protected void clearColor() {
        this.setColor(null);
    }

    protected void setColor(Color c) {
        if (c == null) {
            c = new Color(255, 255, 255);
        }
        this.targetColor = c;
    }

    protected void advanceColor(double dt) {
        if (this.currentColor.equals(this.targetColor)) {
            return;
        }
        this.setColorImmediate(this.currentColor.blend(this.targetColor, dt / 0.2));
    }
}

