package cs2110.assignment1.test;

import java.io.IOException;
import java.io.PrintStream;

import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

public class TestListener extends TestListenerAdapter {
	
	public PrintStream out;
	private int columns;
	private int indent;
	String indentStr;
	private String fmt;
	private CaptureOutputStream buffer;
	
	public TestListener() {
		out = System.out;
		columns = 100;
		indent = 2;
		configure();
		buffer = null;
	}

	public TestListener(TestListener superTest) {
		columns = superTest.columns;
		indent = superTest.indent + 2;
		out = superTest.out;
		configure();
		buffer = new CaptureOutputStream();
		out = new PrintStream(buffer);
	}

	private void configure() {
		indentStr = "";
		for(int i = 0; i < indent; i++) 
			indentStr += " ";
		//int rsltwidth = 7;
		//int rcols = columns - indent - rsltwidth;
		fmt = "%-6s " + indentStr + "%s\n";
	}
	

	//private ITestResult currentTest;
	private TestListener currentSubListener;
	
	@Override
	public void onTestStart(ITestResult r) {
		super.onTestStart(r);
		//currentTest = r;
		currentSubListener = null;
	}
	
	public void printf(String fmt, Object... objs) {
		out.printf(indentStr + fmt, objs);
	}

	public void println(String s) {
		out.println("     " + indentStr + s);
	}

	public void dump(PrintStream x) {
		if(buffer != null)
			try {
				buffer.dump(x);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	
	@Override
	public void onTestSuccess(ITestResult r) {
		out.printf(fmt, "[OK]",getDesc(r));
		if(currentSubListener != null)
			currentSubListener.dump(out);
		super.onTestSuccess(r);
	}
	
	@Override 
	public void onFinish(ITestContext tc) {
		super.onFinish(tc);
	}
	
	private String getDesc(ITestResult r) {
		String d = r.getMethod().getDescription();
		if(d == null)
			return r.getName();
		else 
			return d;
	}
		
	@Override
	public void onTestFailure(ITestResult r) {
		out.printf(fmt, "[FAIL]",getDesc(r));
		if(currentSubListener != null)
			currentSubListener.dump(out);
		super.onTestFailure(r);
		
		if(currentSubListener == null) {
			out.println("---------------------------------------------------");
			Throwable t = r.getThrowable();
			if(t instanceof ThrowableWrapper) {
				t = ((ThrowableWrapper) t).getCause();
			}
			t.printStackTrace(out);
			out.println("---------------------------------------------------");
		}

	}
	
	public TestListener newSubListener() {
		currentSubListener = new TestListener(this);
		return currentSubListener;
	}
	
	public void runTest(Class<?> klass, int verbose) {
		//System.out.println("RUN TESTS FROM " + klass.getName());
		TestNG testng = new TestNG();
		testng.setVerbose(verbose);
		testng.setTestClasses(new Class<?>[] {klass});
		testng.addListener(this);
		testng.run();
	}
	
	public void runTest(Class<?> klass) {
		runTest(klass, 0);
	}

	public boolean passedAllTests() {
		return (getFailedTests().size() == 0);
	}
}
