package cs2110.assignment1.test;


import java.util.LinkedList;
import java.util.List;
import org.testng.annotations.*;
import static org.testng.AssertJUnit.*;


public class TestImplementations {
	
	public static void configure(TestListener lst, String iface, Class<?> testKlass) {
		testClass = testKlass;
		listener = lst;
		interfaceName = iface;
	}
	
	public static TestListener listener;
	private static String interfaceName;
	public static Class<?> testClass; // set by configure
	
	private static List<Class<?>> implementations; // set by findImplementations
	private static List<Class<?>> correctImplementations; // set by findCorrectImplementations
	
	@Test(description = "Search Jar for implementations")
	public void findImplementations() throws Exception {
		implementations = JarTest.jar.findClassesImplementing(interfaceName);
		if(implementations.size() == 0) {
			throw new Exception("No implementations found");
		}
	}
	
	@Test(description = "Check implementations for correctness", dependsOnMethods={"findImplementations"})
	public void findCorrectImplementations() {
		correctImplementations = new LinkedList<Class<?>>();
		for(Class<?> implementation : implementations) {	
			TestListener subl = listener.newSubListener();
			String shortIface = interfaceName.substring(interfaceName.lastIndexOf('.')+1,interfaceName.length());
			subl.println(">>>>>>>> " + implementation.getName() + " implements " + shortIface);
			TestImplementation.configure(subl, implementation);
			subl.runTest(TestImplementation.class);
						
			if(subl.passedAllTests()) {
				correctImplementations.add(implementation);
			}
		}
		assertTrue(correctImplementations.size() > 0);
		
	}

	

}
