package cs2110.assignment1.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.testng.annotations.*;

import static org.testng.AssertJUnit.*;

import cs2110.assignment1.SpeciesReader;

/** Test a SpeciesReader implementation.
 *  
 *  Note: You will have to replace the MySpeciesReader class name with that of your own,
 *  and point the args array to one or more .dat files. 
 */
public class SpeciesReaderTest {

	static File tempDir = null;


	public static File getTempDir() {
		if(tempDir == null) 
			tempDir = TestImplementation.createTempDir();
		return tempDir;
	}
	
	@SuppressWarnings("unchecked")
	@Test(description = "Has constructor \"public Classname(String filename) throws IOException\"")
	public void hasConstructor() throws SecurityException, NoSuchMethodException {
		constructor = (Constructor<? extends SpeciesReader>) TestImplementation.implementationClass.getConstructor(String.class);
		for(Class<?> etype : constructor.getExceptionTypes()) {
			while(etype != Throwable.class) {
				if(etype == IOException.class)
					return;
				etype = etype.getSuperclass();
			}
		}	
		fail("Constructor should throw an IOException when a non-existent filename is given");
	}

	@Test(expectedExceptions={IOException.class,FileNotFoundException.class}, description="Non-existent file throws exception", dependsOnMethods={"hasConstructor"})
	public void testNonExistentFile() throws Throwable  {
		@SuppressWarnings("unused")
		SpeciesReader sr = instantiate("non-existent file");
	
	}

	@Test(description="Test Biscuit.dat", dependsOnMethods={"determineFeed"})
	public void testBiscuit() throws Throwable {
		testReader(biscuit);
	}

	@Test(description="Test Biscuit.dat with gratuitous whitespace", dependsOnMethods={"testBiscuit"})
	public void testBiscuitWhitespace() throws Throwable {
		biscuit.addWhitespace = true;
		testReader(biscuit);
	}


	@Test(description="Assorted species collection", dependsOnMethods={"testBiscuit"})
	public void testCollection() throws Throwable {
		for(TestFile test : fakeAnimals) {
			testReader(test);
		}
	}
	
	@Test(description="Determine line break type", dependsOnMethods={"hasConstructor"})
	public void determineFeed() throws Throwable {
		String lf = null;
		try {
			TestFile.linefeed = "\r\n";
			testReader(biscuit);
			getListener().println("[OK]      DOS line breaks (\\r\\n)");
			lf = TestFile.linefeed;
		} catch(Throwable t) {
			getListener().println("[FAIL]      DOS line breaks (\\r\\n)");
		}
		
		try {
			TestFile.linefeed = "\r\n";
			testReader(biscuit);
			getListener().println("[OK]      UNIX linefeeds (\\n)");
			lf = TestFile.linefeed;
		} catch(Throwable t) {
			getListener().println("[FAIL]      UNIX linefeeds (\\n)");
		}

		if(lf == null) {
			getListener().println("Neither linefeed works. Default to DOS linefeeds");
			TestFile.linefeed = "\r\n";
		} else {
			TestFile.linefeed = lf;
		}
		
	}
	
	public void testReader(TestFile test) throws Throwable {
		test.write();
		try {
			@SuppressWarnings("unused")
			SpeciesReader reader = instantiate(test.path);
		} catch(Throwable t) {
			test.readerFail(-1);
			throw new ThrowableWrapper(t);
		}
		test.run(instantiate(test.path));
	}

	public static class TestFile {
		public String path;
		private String content;
		private String[] commands;
		private String[] arguments;
		
		public boolean addWhitespace = false;
		
		public TestFile(String filename, String[] commands, String[] arguments) {
			this.path = getTempDir().getAbsolutePath() + File.separator + filename;
			this.commands = commands;
			this.arguments = arguments;
			
		}

		public TestFile(String[] commands, String[] arguments) {
			this.path = getTempDir().getAbsolutePath() + File.separator + "test.dat";
			this.commands = commands;
			this.arguments = arguments;
		}
		
		static String linefeed = "\n";
		
		public void run(SpeciesReader reader) throws Exception {
			int i = 0;
	
			while(true) {
				String command = reader.getCommand() ;
				String argument = reader.getArgument();
				
				if(command == null || !command.equals(commands[i])) 
					readerFail(i, "getCommand() returned \""+command+"\"");
				if(argument == null || !argument.equals(arguments[i])) 
					readerFail(i, String.format("getCommand() returned \"%s\"", command));
				
				boolean eof = !reader.readNextLine();
				i++;
				if(eof) {
					if(i >= commands.length) 
						break;
					else 
						readerFail(i, "readNextLine() indicated premature end-of-file");
				} else if(i >= commands.length){
					readerFail(-1, "readNextLine() failed to return false after last valid line");
				}
			}
			delete();
		}
		
		private void readerFail(int line, String msg) throws Exception {
			if(line == 0) 
				getListener().println("Tip: The constructor should leave SpeciesReader in a state where getCommand() and getArgument() work, without readNextLine being called first.");
			if(line > 0) {
				getListener().println("SpeciesReader failure at line " + (line+1) + ": " + msg);
			} else {
				getListener().println("SpeciesReader failure: "+msg);
			}
			getListener().out.println("------ File -------------------------------------");
			int i = 0;
			for(String l : getContent().split("\r\n|\n")) {
				if(i++ == line) 
					getListener().out.printf("%-60s<------------ error\n", l);
				else 
					getListener().out.println(l);
			}
			getListener().out.println("-------------------------------------------------");
			fail(msg);
		}
		
		private void readerFail(int line) throws Exception {
			getListener().out.println("------ File -------------------------------------");
			int i = 0;
			for(String l : getContent().split("\r\n|\n")) {
				if(i++ == line) 
					getListener().out.printf("%-60s<------------ error\n", l);
				else 
					getListener().out.println(l);
			}
			getListener().out.println("-------------------------------------------------");
		}
		
		public File getFile() {
			return new File(path);
		}
		
		public String getContent() throws Exception {
			generateDefaultContent();
			return content;
		}
		
		public void generateDefaultContent() throws Exception {
			StringBuffer buffer = new StringBuffer();
			if(commands.length != arguments.length) {
				throw new Exception("Numbers of commands and arguments differ");
			}
			for(int i = 0; i < commands.length; i++) {
				// Sanity checks
				if(!commands[i].matches("[a-zA-Z]+") || !arguments[i].matches("^[^\"]*$")) {
					throw new Exception("Internal testing error: supplied commands and arguments are invalid");
				}
				
				if(!addWhitespace)
					buffer.append(String.format("%s=\"%s\"" + TestFile.linefeed, commands[i], arguments[i]));
				else
					buffer.append(String.format("    %s  = \"%s\"         " + TestFile.linefeed, commands[i], arguments[i]));

			}
			content = buffer.toString();
		}
		
		public void write() throws Exception {
			FileWriter fr = new FileWriter(path);
			fr.write(getContent());
			fr.close();
			assert(getFile().exists());
		}

		public void delete() {
			File f = new File(path);
			if(f.exists())
				f.delete();
		}
	}

	public static TestListener getListener() {
		return TestImplementation.testListener;
	}
	
	private static TestFile biscuit = new TestFile("biscuit.dat", 
			new String[] {"Name", "LatinName", "Image", "DNA"},
			new String[] {"Biscuit", "Retrieverus_Aurum", "Biscuit.bmp", "ACIOCAIOACIOOAACIIIOCAOCAOOAACIOCAIOACIOOAACIIIOCAOCAOOA"});
	


	private static Constructor<? extends SpeciesReader> constructor = null; // set by hasConstructor

	private SpeciesReader instantiate(String filename) throws Throwable  {
		// Find constructor
		SpeciesReader r = null;
		if(constructor == null)
			throw new Exception("Internal error: Test called out of order");

		try {
			r = constructor.newInstance(filename);
		} catch (InvocationTargetException e) {
			throw e.getCause();
//			fail("Constructor threw " + e.getCause().getClass().getName());
		}
		return r;
	}

	TestFile[] fakeAnimals = {
		    new TestFile(new String[]{"Name","LatinName","Image"},new String[]{"Armored_Snapper","Armored_Snapperus","Armored_Snapper.bmp"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Leaping_Lizard","Leaping_Lizard.bmp","AIOAOIIAIIAAIIIOOOOOAOAAICCOACOICOICICOCICOACIOACCCACIAACCCCCCCOCAICCOICCOCCCIOICICOIOIAOOAIACIIAIOO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Hairy_Rock_Snot","Hairy_Rock_Snot.bmp","AOACAAIOOIOIOACIICOIOAIIIIAAICCIAIIOICIIICCCACACAAOICOCCCAIOOOIACIAACICOCOIIOOIOICOCOAIACICIOACIICIC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Toothy_Ballonfish","Toothy_Ballonfish.bmp","AAAACIOAOACIOAAOIAOICOAIAACCCAIAAIIOAAAOIAAIAIIAOICOAACIAIOOOIAOACOIIAAOIOCAAOOCOOAOAAOACAOICIIAACCC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Elephant_Snark","Elephant_Snark.bmp","ACIAIICIOOIOIAIOOAACAOICOCAOAAAIIACCCOOOOCOAAOAIOOIIOAOOCAIOIOOCOOAOAIAOOCOOOICIOCOIICOOAOOICOCOIIAO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Asian_Boxing_Lobster","Asian_Boxing_Lobster.bmp","AICCIACAOAACCCIIOOCICIAAIOCIAACOCOOAAAACOIAICIAAIOIOCCAAAIICOICCOIIACCCIIAIAOOAIOIOICIIOOAOIAIICCACI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Sextopus","Sextopus.bmp","AAICOIICOIIOOCCIOCACCCCOOCOOIOACOIAOOOIIACIAAIAIAOAOIIIIOCAICCOAAOIIIOCIOIACCCOOOACCIAAOOCCIIAOOCICO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Parmesanian","Parmesanian.bmp","AIOAOOCIAOAIOOIIIAAAIACIOOIICOICIIAACCOIAOIOOCAAACAAAAAIIAIOCCAAOACCCACOAOIAIACCIAIIIIAIOCCCIICIOAOI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Frilly_Sea_Sprat","Frilly_Sea_Sprat.bmp","AOIICICCIAOAICCIOIOOIACOCIAAOIIOCIIIICCOOCOCOIAACOOOIICCIACAIOCACIAACIIOCCCACAAIOCAIIACOCIAIOIICOAOO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Munkles_Mouse","Munkles_Mouse.bmp","AOAAIIACOOAOIOCOAOOACACIACIOAAICIACCOOACIIOCAACICOIIAIOCACCICOOCCCCAICOCIIICOICIOICOCAICOCOOICCAAIIC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Ballards_Hooting_Crane","Ballards_Hooting_Crane.bmp","ACICCOICCAOIAOOAAAACAAOOIAOAIOACAAOIAIOIOOAIACAOACCAAACAIIOAAIICCAOAIAOAICOICOACOIOACIICIAOAAICCCAII"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Ballards_ProtoDuck","Ballards_ProtoDuck.bmp","AAOIAOICOIIAACCIACIAAOIIOCOAICCACOAAAOAIIAIAIIOCCIIOIOCACACOIACACACOIIOIAAAAOIACCCCCIAOIAOOCIIOIOCOI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Fuzzy_Trible","Fuzzy_Trible.bmp","AOAIAOOOAICOIIAIIAOOIOCIICCCIIAAOICCACOIIIICOAOAAAOOICOIIIACICCAOOAOOCCCOACOAIICOIOICIIAAAOOCAAIAOII"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Nocturnal_Mourningbird","Nocturnal_Mourningbird.bmp","AOIIOAAAAIOOAOIIOAICIAACAOOCCICOACAAOAAACAIOACAAOAIAAAOOCIIAIOAIOCCICOOAAIAOAIOICOACCAICOCCIAOAOIOII"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Shy_Frecklepuss","Shy_Frecklepuss.bmp","AIIAOAIOCAACOAOAIAACOCACCAAOOIOAAIAIOIOCAACCAOAOIOCIICCAIOCACIOOCOIIIACIAIACAIOOICOCCIAIOOIIAOOIAAOA"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Globe_Floater","Globe_Floater.bmp","AIIIAACOIIIACIOOIOCCICCOIIACAACIIICOCACOCAIOOIOCIICCOOOOAAIOCAAOOCAIIOAICCOOOCOIIIICICICCOIAACIIAAOO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Gilligans_Squimp","Gilligans_Squimp.bmp","AAAIIIICCIIOCCIIIIAAAAOIOOOOCOAACCAAIACIAICCOCCCACCIOIAAACOCACOAACOCOAAOAOAIICCACOAAAICCIOOIOICOCCOO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Nocturnal_Plexum","Nocturnal_Plexum.bmp","ACIAAOAICIOCIOOAICCIIICOCAIICOICOIIIAAIAACCIAICOAAAACCOOACACICOOCOIAAACAAAOAOIIOOAAAIOIAOACAICCICIAI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Snuffling_Blat","Snuffling_Blat.bmp","ACIAOIAIIAIOACOOIACAIIIOACIIICIIIIAICICIAOOCACIOAAIIIAOIIAOOAAIAAIIAICCCOOOIIOOOACOICOOAOICCOCOACIOC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Bards_Star","Bards_Star.bmp","AIAIAAOAOOCOAICCOAAIOOIACCIIOACIIOOCAIAAACOOCIAICCCOOCOOOOCCAIIIIOAAAOIAICCOACOAIICIOCIOAOAICICIICOI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Gray_Floop","Gray_Floop.bmp","AOIOOCCCICIAICICOAOAAIAOOOOAOAOICCAIAIIAICIIIOCAOAICCCCOOACACIIOIOCCACACIOCIAIAAIAACOCOACCOIIIOIIAIO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Paradise_Rockfish","Paradise_Rockfish.bmp","AACACOIAOAIOIOCOIAACCOIOCCOOOAIOACICCIOOICOOICCAOAIAAIICCCIAAOAIOACAOOCCCICOAOIOICOAOOOCOOCCOOIIAIIC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Spotted_Ghila","Spotted_Ghila.bmp","AIOIIACOOIAICCIIIIOIOOCOACAOIAIOOAICIAICCCAAOAAOIAOOICCCCICCAIACIOOOCOAIOIOCCCCIACIACAAIOCIAAIOCOCCC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Big-Billed_Peacock","Big-Billed_Peacock.bmp","AOIOCOAAOAOAOOICCCAAAACCIOCCCIOAAAAAAAIOIACOOIOAACCAIIOIIAOAAOOACACAAIAICOOOCACAICOIAAAAIACCCCIOIICI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Green_Herring","Green_Herring.bmp","AOICCOAAIOOAOIAOOOOAAOIAACOCAAIOCCACCOAIOAAIIAOAOIACOICCOICIAICIOCOIIOAIAAOIIOOICCAACIIICCOCCCCIOCIO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Translucent_Tridle","Translucent_Tridle.bmp","ACOCICICCAIIAOACCACOAOOIAOAOACIAAIIOACOCCACAOOOCOCAAACCIAAAICCCCICOOAICICCIAOAOAIOIOAAAIOOCCACICCAAA"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Sprats_Butterfly","Sprats_Butterfly.bmp","AOOOAAACOCIIOCIIIAIIAIOOOOACCAAOIIAOICOACCIIIIOOOIIICOIOOIAAOIIOCAIAIIOICIOOOOCICOAOOOIOAACACOOIOCAO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Common_Mudfly","Common_Mudfly.bmp","ACAAIACACAIAAIICOACCIAIIAIACCICCOAIAOAIIAAAOAAAIOCICIOCIIIOOOCIICCCAICCCACIIACACOCAAICIIIIIIAAOIIAAO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Green_SnapDragon","Green_SnapDragon.bmp","ACIOIAIAACAICOAOAAOOAOAOACOIACAOACCCOCACCCOOOIIOOIIOIIOCAAIIACICOIIIIIOIOIOCICCIAOOOICIOAACOACAAACCI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Pink_Ziffer","Pink_Ziffer.bmp","AIOOIIACCACCOAAIOAOICOAIICOAOOAIOOIICCOOAOIIOOIOAAOIICCAACCAIOOAACAOAOIIOIOAIIIOCIOOAOOIIIIIIOCICOII"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Strats_Squirrel","Strats_Squirrel.bmp","AIIOOOIICOCCICOCAOOAICOAIOCCOOCCACOOOIACOACACOAIACIOAOOIICOIICCIICICOCICIOOCICIICICOAAOOCICIOIAOAICO"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Hallucigenia","Hallucigenia.bmp","ACCAAAICOOIACICCACAAOOCIICOICOOOOIIOCICIIACAAICOAAACAOOAOOOIACIAOAIOAOICOCOAOIICIOCIACACCCAOOAACOOCI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Jelly_Belly","Jelly_Belly.bmp","OCIOAAACOAIIOICOIOCCAOOACAIOCAAAAOAAOAAAOAOAOOIICIOAAIOAOAIIOCCCCCAAOIIIAACAIIACIOCIAICOIOAOACCCOCIC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Policle","Policle.bmp","ACAAOAIICCCCIOIOAIOOOACIOCAICOAACICCAOICIAAIAOIOICOCOAIAOIAAIOICOCOOAIOCAIIAAACIAOOIICCACOAOOACAAAAC"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Striped_Salamander","Striped_Salamander.bmp","AACCCAAAIIOIOIICCCIAIAAIIOIAOACOIAIAIICOCOOCOACOAAIIOAAOIOIIACCAIAIAIOCACIOOCOIIACAIIOIAACOAAAOIOAOI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Darwins_Tortle","Darwins_Tortle.bmp","ACIIIOCIOAAAICIAOOAAOAIIACICOIAAACICCCOCIAIICIAIOAOOOIIAIAAAOOAIOIAOICIAAIIOOCOOIAIOIACAOOOACAIIIAAI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Larval_TreeNymph","Larval_TreeNymph.bmp","ACIOOIOOAOIIIOOAOAIICOCOOAAIIIAOOACAOOOOAIAACCOACCAOOIIACOCOACAOOCCCCOAAAIICICICCCCOOOOAICCCOIICOOCA"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Pompous_Snark","Pompous_Snark.bmp","ACCAOOOACCAAIIIAICCCIIIACOICIAOOICOAACACAOACOAOOAIICICCIOAIAOOCCIOOICOCIOCCICOIIOAAIOAOIOOAIIACIACCI"}),
		    new TestFile(new String[]{"Name","Image","DNA"},new String[]{"Swamp_Slime","Swamp_Slime.bmp","ACIIAAIOAOAOOAOICCCCOAIOOCAACAAAOICIOCAAIAOAOIAOAIOCIIIOAACCOICICOOACACAICOIICCCAIICCACIOAICCIIIOIII"}),
		};

	public static void main(String args[]) {
		if(args.length != 1) {
			System.err.println("SpeciesReaderTest.main takes the full name of your class as its only argument");
			System.exit(1);
		}
		
		TestImplementation.singleClass(args[0], SpeciesReaderTest.class);
	}
}


