package cs2110.assignment1.test;

import java.io.*;
import java.util.zip.ZipException;
import org.testng.annotations.*;

import static org.testng.AssertJUnit.*;

/*
 *  ComplianceTool.main is the launch point for the compliance
 *  testing tool.  It takes one command line argument, the path
 *  to a student's JAR file.
 * 
 *  DNAParserTest, SpeciesReaderTest, and GenomeTest contain junit
 *  tests for the three interfaces.
 *  
 */

public class JarTest {

	public static final long RANDOM_SEED = 12345;

	public static boolean compileSources = false;
		
	public static String jarFile = null;
	
	public static JarInspector jar = null;
	
	public JarInspector getJar() {
		if(jar != null) return jar;
		assertNotNull(jarFile);
		assertTrue(jarFile.toLowerCase().endsWith(".jar"));
		assertTrue(new File(jarFile).exists());
		try {
			jar = new JarInspector(jarFile);
			return jar;
		} catch (ZipException e) {
			// TODO Auto-generated catch block
			fail("ZipException loading jar file " + jarFile + ": " + e);
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			fail("IOException loading jar file " + jarFile + ": " + e);
			return null;
		}
	}

	@Test(description = "Load Jar File")
	public void loadJar() {
		listener.out.println("   Opening " + jarFile + "...");
		assertNotNull(getJar());
	}
		
	@Test(description="Contains correct DNAParser implementation", dependsOnMethods={"loadJar"})
	public void checkDNAParser() {
		TestListener subl = listener.newSubListener();
		TestImplementations.configure(subl, "cs2110.assignment1.DNAParser", DNAParserTest.class);
		subl.runTest(TestImplementations.class);
		assertTrue(subl.passedAllTests());
	}
	
	@Test(description="Contains correct SpeciesReader implementation", dependsOnMethods={"loadJar"})
	public void checkSpeciesReader() {
		TestListener subl = listener.newSubListener();
		TestImplementations.configure(subl, "cs2110.assignment1.SpeciesReader", SpeciesReaderTest.class);
		subl.runTest(TestImplementations.class);
		assertTrue(subl.passedAllTests());
	}
	
	@Test(description="Contains correct Genome implementation", dependsOnMethods={"loadJar"})
	public void checkGenome() {
		TestListener subl = listener.newSubListener();
		TestImplementations.configure(subl, "cs2110.assignment1.Genome", GenomeTest.class);
		subl.runTest(TestImplementations.class);
		assertTrue(subl.passedAllTests());
	}

	

	public static final int version = 1;
	
	public static TestListener listener; 

}
