package cs2110.assignment1.test;

import java.io.*;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.*;

public class JarInspector {

	static class ByteClassLoader extends ClassLoader {
		public Class<?> classFromBytes(String name, byte[] data) {
			return defineClass(name,data, 0, data.length);
		}
	}
	
	private String filename; 
	
	public JarInspector(String filename) throws ZipException, IOException {
		this.filename = filename;
	}

	public String getSourceName(Class<?> klass) {
		String classname = klass.getName();
		String sourcename = classname.substring(classname.lastIndexOf('.')+1,classname.length()) + ".java";
		return sourcename;
	}
	
	public byte[] getSource(Class<?> klass) throws ZipException, IOException {
		ZipFile zf = new ZipFile(filename);
		String classname = klass.getName();
		String sourcename = classname.replace('.','/') + ".java";
		ZipEntry sourceEntry = zf.getEntry(sourcename);
		if(sourceEntry == null)  // bad
			return null;
		byte[] data = readEntry(zf,sourceEntry);
		return data;
	}
	
	private byte[] readEntry(ZipFile zf, ZipEntry z) throws IOException {
		int len = (int) z.getSize();
		int offset = 0;
		byte[] data = new byte[len];
		InputStream is = zf.getInputStream(z);
		
		while(len > 0) {
			long bytesRead = is.read(data,offset,len);
			len -= bytesRead;
			offset += bytesRead;
		}
		is.close();

		return data;
	}
	
	public LinkedList<Class<?>> findClasses() throws ZipException, IOException {
		// Return all classes defined in the JAR file
		ZipFile zf = new ZipFile(filename);
		Enumeration<? extends ZipEntry> en = zf.entries();
		LinkedList<Class<?>> results = new LinkedList<Class<?>>();
		while(en.hasMoreElements()) {
			ZipEntry z = en.nextElement();
			if(!z.getName().endsWith(".class"))
				continue;
			String classname = z.getName().substring(0,z.getName().indexOf('.'));
			
			byte[] data = readEntry(zf,z);
			
			ByteClassLoader cl = new ByteClassLoader();
			
			classname = classname.replace("/",".");
			Class<?> k = (Class<?>) cl.classFromBytes(classname, data);
			results.add(k);
			
		}
		zf.close();
		return results;
		
	}
	public LinkedList<Class<?>> findClassesImplementing(String interfaceName) throws ZipException, IOException {
		//System.out.println(" -- find classes implementing " + interfaceName);
		LinkedList<Class<?>> results = new LinkedList<Class<?>>();
		for(Class<?> c : findClasses()) {
			for(Class<?> i : c.getInterfaces()) {	
				//System.out.println( "      interface " + i.getName());
				if(i.getName().equals(interfaceName)) {
					//System.out.println("     matches : " + c.getName());
					results.add(c);
					break;
				}
			}
		}
		return results;
	}
	
}
