package cs2110.assignment1.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import cs2110.assignment1.DNAParser;
import cs2110.assignment1.Genome;
import org.testng.annotations.*;

import static org.testng.AssertJUnit.*;


public class GenomeTest {
	
	@Test(description = "Test one gene", dependsOnMethods={"hasConstructor"})
	public void oneGene() throws Exception {
		assertTrue(compareWithReferenceSolution(new String[] {"AAA"}));
	}
	
	@Test(description = "Test random genes", dependsOnMethods={"oneGene"})
	public void randomGenes() throws Exception {
		Random rand = new Random(JarTest.RANDOM_SEED);
		for(int i = 0; i < 1000; i++) {
			String DNA = DNAParserTest.generateRandomDNA(rand, 900);
			DNAParser parser = new cs2110.assignment1.solution.MyDNAParser(DNA);
			LinkedList<String> genes = new LinkedList<String>();
			while(true) {
				String gene = parser.getNextGene();
				if(gene == null) break;
				genes.add(gene);
			}
			assertTrue(compareWithReferenceSolution(genes));
		}
	}
	
	private static Constructor<? extends Genome> constructor = null; // set by hasConstructor

	@SuppressWarnings("unchecked")
	@Test(description = "Has default constructor")
	public void hasConstructor() throws SecurityException, NoSuchMethodException {
		constructor = (Constructor<? extends Genome>) TestImplementation.implementationClass.getConstructor();
	}
	
	private Genome instantiate() throws Exception  {
		// Find constructor
		Genome g = null;
		if(constructor == null)
		throw new Exception("Internal error: Test called out of order");
		
		try {
			g = constructor.newInstance();
		} catch (InvocationTargetException e) {
			fail("Constructor threw " + e.getCause().getClass().getName());
		}
		return g;
	}
	
	private boolean compareWithReferenceSolution(String[] genes) throws Exception {
		ArrayList<String> temp = new ArrayList<String>();
		for(String gene : genes) 
			temp.add(gene);
		return compareWithReferenceSolution(temp);
	}
	
	private boolean compareWithReferenceSolution(List<String> genes) throws Exception {
		if(!(genes instanceof ArrayList<?>))
			genes = new ArrayList<String>(genes);

		if(genes.size() == 0) return true;
		Genome student = instantiate();
		Genome reference = new cs2110.assignment1.solution.MyGenome();
		
		String classname = student.getClass().getName();
		
		for(int j = 0; j < 2; j++) {
			for(String gene : genes) {
				int refnum = reference.addGene(gene);
				if(refnum != student.addGene(gene)) {
					if(j == 0)
						if(refnum == 0)
							fail("The first gene added to a Genome should be numbered 0");
						else
							fail("Return value of " + classname + ".addGene() differs from reference implementation on newly added gene");
					else
						fail("Adding a gene already in the Genome should not assign a new number");		
					return false;
				}
			}

			// Do some randomly ordered lookups
			Random rand = new Random(JarTest.RANDOM_SEED);
			for(int i = 0; i < 100; i++) {
				String gene = genes.get(rand.nextInt(genes.size()));
				if(student.lookupGene(gene) != reference.lookupGene(gene)) {
					TestImplementation.testListener.println("Return value of " + classname + ".lookupGene() differs from reference implementation during randomly ordered lookups");
					return false;
				}
			}
		}
	
		return true;
	}
	
	public static void main(String args[]) {
		if(args.length != 1) {
			System.err.println("GenomeTest.main takes the full name of your class as its only argument");
			System.exit(1);
		}
		
		TestImplementation.singleClass(args[0], GenomeTest.class);
	}

}
