package cs2110.assignment1.test;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import cs2110.assignment1.SpeciesReader;
import cs2110.assignment1.solution.MySpeciesReader;

public class GenerateFakeAnimals {
	public static void main(String[] args) throws IOException {
		System.out.println("TestFile[] fakeAnimals = {");

		for(String arg : args) {
			SpeciesReader reader = new MySpeciesReader(arg);
			LinkedList<String> commands = new LinkedList<String>();
			LinkedList<String> arguments = new LinkedList<String>();
			while(true) {
				String argument = reader.getArgument();
				String command = reader.getCommand();
				if(argument.length() > 100) {
					argument = argument.substring(0,100);
				}
				if(command == null) break;
				commands.add(command);
				arguments.add(argument);
				if(!reader.readNextLine()) 
					break;
			}
	
			System.out.printf("    new TestFile(new String[]{%s},new String[]{%s}),\n",join(commands), join(arguments));

		}
		System.out.println("}");

	}
	
	static String join(List<String> elements) {
		StringBuffer buffer = new StringBuffer();
		int i = 0;
		for(String l : elements) {
			if(i++ > 0) {
				buffer.append(",");
			}
			buffer.append("\"" + l + "\"");
		}
		return buffer.toString();
	}
}
