package cs2110.assignment1.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import cs2110.assignment1.DNAParser;
import org.testng.annotations.*;
import static org.testng.AssertJUnit.*;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class DNAParserTest {
	
	
	private static Constructor<? extends DNAParser> constructor = null; // set by hasConstructor
	
	private DNAParser instantiate(String DNA) throws Exception  {
		// Find constructor
		DNAParser p = null;
		if(constructor == null)
			throw new Exception("Internal error: Test called out of order");
		
		try {
			p = constructor.newInstance(DNA);
		} catch (InvocationTargetException e) {
			fail("Constructor threw " + e.getCause().getClass().getName());
		}
		return p;
	}

	@SuppressWarnings("unchecked")
	@Test(description = "Has constructor \"public Classname(String DNA)\"")
	public void hasConstructor() throws SecurityException, NoSuchMethodException {
		constructor = (Constructor<? extends DNAParser>) TestImplementation.implementationClass.getConstructor(String.class);
	}
	
	@Test(description = "Test zero genes", dependsOnMethods = {"hasConstructor"})
	public void testZeroGenes() throws ThrowableWrapper, Exception {
		assertTrue(compareWithReferenceSolution("AICAAAICA"));
	}
	
	@Test(description = "Test one gene", dependsOnMethods = {"hasConstructor"})
	public void testOneGene() throws ThrowableWrapper, Exception {
		assertTrue(compareWithReferenceSolution("AOCAAAICA"));
	}

	@Test(description = "Test unterminated gene", dependsOnMethods = {"hasConstructor"})
	public void testUnterminated() throws ThrowableWrapper, Exception {
		assertTrue(compareWithReferenceSolution("AICAAAIIA"));
	}

	
	private boolean compareWithReferenceSolution(String dna) throws Exception, ThrowableWrapper {
		DNAParser dp = instantiate(dna);
		DNAParser ref = new cs2110.assignment1.solution.MyDNAParser(dna);
		
		// Get reference solution
		
		// First try without comparing to the ref solution
		
		Solution refsol = null;
		
		try {
			refsol = new Solution(ref);
			if(refsol.containsEmptyGenes()) {
				throw new Exception("Internal error: test dna should not have empty genes");
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			System.out.println("ERROR: Reference solution is broken.");
			System.out.println("Please email this DNA sequence to lonnie@cs.cornell.edu:");
			System.out.println(dna);
			e.printStackTrace();
			System.exit(1);
			return false;
		}
		
		Solution studentsol;

		try {
			studentsol = new Solution(dp);
		} catch (Exception e) {
			getListener().println(dp.getClass().getName() + " failed on the following DNA input.  See stack trace below for details.");
			getListener().println(dna);
			throw new ThrowableWrapper(e);
		}

		if(!studentsol.equals(refsol)) {
			getListener().println(dp.getClass().getName() + " does not agree with the reference solution on the following DNA input");
			getListener().println(dna);
			printSolutions(dp.getClass().getName(), studentsol, refsol);
			return false;
		}

		return true;
	}
	
	private TestListener getListener() {
		return TestImplementation.testListener;
	}
	
	public void printSolutions(String classname, Solution sol, Solution refsol) {
		TestImplementation.testListener.println("Solution comparison");
		TestImplementation.testListener.println("Counts: " + sol.count + " vs. " + refsol.count);
		TestImplementation.testListener.printf("%-3s %-5s %-40s %-40s\n", "#", "Same?", classname, "Reference Solution");
		TestImplementation.testListener.println("-------------------------------------------------------------------------");
		Iterator<String> i = sol.genes.iterator();
		Iterator<String> j = refsol.genes.iterator();
		int n = 1;
		while(i.hasNext() || j.hasNext()) {
			String a;
			String b;
			if(i.hasNext())
				a = i.next();
			else 
				a = "";
			
			if(j.hasNext()) 
				b = j.next();
			else
				b = "";
			String dif = "";
			if(!a.equals(b)) {
				dif = "!!!";
			}
			TestImplementation.testListener.printf("%-3s %-5s %-40s %-40s\n",n++,dif,a,b);
		}
		TestImplementation.testListener.println("--------------------------------------------------------------------------");
		
	}

	
	@Test(description = "1000 random DNA sequences of length 50", dependsOnMethods={"testOneGene","testZeroGenes","testUnterminated"})
	public void testRandomGenes() throws Exception, ThrowableWrapper {
		Random rand = new Random(JarTest.RANDOM_SEED);
		//TestListener sl = TestImplementation.testListener.newSubListener();
		//sl.println("  Random seed: " + randomSeed);
		//sl.println("  Note: A different random seed will be used for grading");
		
		for(int i = 0; i < 1000; i++) {
			String dna = generateRandomDNA(rand, 50);
			
			// test sanity check
			if(dna.indexOf("AOCICA") > -1) {
				throw new Exception("Internal error: empty gene found in random DNA string");
			}
			assertTrue(compareWithReferenceSolution(dna));
		}
		
	}

	@Test(description = "1000 random DNA sequences of length 900", dependsOnMethods={"testRandomGenes"})
	public void testRandomGenes2() throws Exception, ThrowableWrapper {
		Random rand = new Random(JarTest.RANDOM_SEED);
		//TestListener sl = TestImplementation.testListener.newSubListener();
		
		for(int i = 0; i < 1000; i++) {
			String dna = generateRandomDNA(rand, 900);
			assertTrue(compareWithReferenceSolution(dna));
		}
		
	}
	
	
	public static String generateRandomDNA(Random rand, int length) throws Exception {
		StringBuffer dna = new StringBuffer(length);
		char[] nucleotides = {'A','I','O','C'};
		
		// Generate random DNA string
		for(int i = 0; i < length; i++) {
			char c = nucleotides[rand.nextInt(4)];
			dna.append(c);
		}
		
		String geneStart = "AOC";
		String geneStop = "ICA";
		//Pattern p = Pattern.compile("AOC([AOCI]+?)ICA");
		// intentionally add some gene start and stop sequences
		for(int j = 0; j < length/5+5; j++) {
			int k = rand.nextInt(length-4);
			dna.replace(k,k+3,geneStart);
			k = rand.nextInt(length-4);
			dna.replace(k,k+3,geneStop);	
		}
		String ds = dna.toString();
		// Remove empty genes -- the assignment did  clearly specify what to do with them
		while(ds.indexOf("AOCICA") != -1) {
			ds = ds.replace("AOCICA", "IOCIOA");
		}
		if(ds.indexOf("AOCICA") != -1)
			throw new Exception("Internal error: empty gene");
		return ds;
	}
	
	private class Solution {
		int count;
		LinkedList<String> genes;
		String classname;
		String solname;
		
		public Solution(DNAParser parser) throws Exception {
			solname = parser.getClass().getName();
			classname = parser.getClass().getName();
			genes = new LinkedList<String>();
			
			count = parser.count();
			
			int maxIterations = 10000; // in case a parser never stops...
			int i = 0;
			
			while(i++ < maxIterations) {
				String gene = parser.getNextGene();
				if(gene == null) 
					break;
				genes.add(gene);
			}
			
			if(i == maxIterations) {
				throw new Exception(classname+".getNextGene() loop terminated after 10000 iterations.  It should return null after reading the last gene.");
			}
			
			if(count != genes.size()) {
				dumpDiagnostics();
				throw new Exception(classname+".count() is inconsistent with the number of genes actually returned by iterating over getNextGene() ");
			}
			
			if(parser.count() != count) 
				throw new Exception(classname+".count() is inconsistent before and after looping over getNextGene()");
			
			parser.reset();
			
			int j = 0;
			while(j++ < maxIterations) 
				if(parser.getNextGene() == null) break;
			
			if(j == maxIterations)
				throw new Exception(classname+".getNextGene() after reset(): loop terminated after 10000 iterations.  It should return null after reading the last gene.");
			
			if(i != j) {
				throw new Exception("Inconsistent number of genes returned after " + solname + ".reset()");
			}			
		}	
		
		private void dumpDiagnostics() {
			getListener().println("Solution: " + solname);
			getListener().printf("   count() = %d   getNextGene() returned %d genes\n",count,genes.size());
			getListener().println("    Genes:");
			int i = 0;
			for(String gene : genes) {
				getListener().println("        " + (i++) + "   " + gene );
			}
			getListener().println("--------------------------------------");
		}
		
	

		public boolean containsEmptyGenes() {
			for(String gene : genes) {
				if(gene.matches("^\\s*$")) {
					return true;
				}
			}
			return false;
		}
		public boolean equals(Solution reference) {
			// When this is called, reference will always be the reference solution.
			// this is the user solution.
			if(reference.count != count) 
				return false;
			
			if(reference.genes.size() != genes.size())
				return false;
			
			Iterator<String> i = reference.genes.iterator();
			// throws AssertionError
			for(String gene : genes) {
				if(!gene.equals(i.next())) {
					return false;
				}
			}
			return true;
		}
	}
	
	public static void main(String args[]) {
		if(args.length != 1) {
			System.err.println("DNAParserTest.main takes the full name of your class as its only argument");
			System.exit(1);
		}
		
		TestImplementation.singleClass(args[0], DNAParserTest.class);
	}

}