package cs2110.assignment1.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class CaptureOutputStream extends OutputStream {

	private LinkedList<byte[]> buffer;
	
	public CaptureOutputStream() {
		buffer = new LinkedList<byte[]>();
	}
	
	@Override
	public void write(int arg0) throws IOException {
		buffer.add( new byte[] {(byte) arg0} );		
	}

	@Override 
	public void write(byte[] b) throws IOException {
		buffer.add(b.clone());
	}
	
	@Override 
	public void write(byte[] b, int offset, int len) throws IOException {
		byte[] b2 = new byte[len];
		System.arraycopy(b, offset, b2, 0, len);
		buffer.add(b2);
	}
	
	public void dump(OutputStream other) throws IOException {
		for(byte[] b : buffer) {
			other.write(b);
		}
	}
}
