package cs2110.assignment1.test;

import java.io.IOException;
import java.util.zip.ZipException;

import org.testng.TestNG;

public class A1ComplianceTool {

	public static final int VERSION = 2;
	
	public static void main(String[] args) throws ZipException, IOException {
		// args[0] is a jar file to be tested
		System.out.println("[Assignment 1 Compliance Tool version " + VERSION + "]");
		System.out.println("[Random seed = " + JarTest.RANDOM_SEED + "   (this will differ for grading)]");
		String filename = null;
		if(args.length > 0) {
			filename = args[0];
		} else {
			System.err.println("Please specify the path of a JAR file as the first argument");
			return;
		}
		JarTest.jarFile = filename;
		args[0] = "cs2110.assignment1.JarTest";
	
		TestListener tla = new TestListener();
		JarTest.listener = tla;
		
		TestNG testng = new TestNG();
		testng.setVerbose(0);
		testng.setTestClasses(new Class[] { JarTest.class });
		testng.addListener(tla);
		testng.run(); 
		System.out.println("-------------------------------------------------------------");
		System.out.printf("Summary of top-level tests:  %d successful out of %d\n", tla.getPassedTests().size(), tla.getPassedTests().size()+tla.getFailedTests().size());
		if(tla.passedAllTests()) {
			System.out.println("SUCCESS");
		} else {
			System.out.println("FAILURE");
		}
	}

}
