import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

import javax.swing.JFrame;

public class Scribble {
	public static void main(String[] args) {
		JFrame w = new JFrame("Scribble");
		w.setSize(500,500);
		w.add(new Scribbler()); // child fills parent: no layout manager needed
		w.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		w.setVisible(true);
	}
	
	public static class Scribbler extends Component {
		Point[] points;
		int npoints;
		
		public void paint(Graphics g) {
			g.setColor(Color.WHITE);
			Rectangle b = g.getClip().getBounds();
			g.fillRect(b.x, b.y, b.width, b.height);
			g.setColor(Color.BLUE);
			for (int i = 0; i < npoints-1; i++) {
				g.drawLine(points[i].x, points[i].y, points[i+1].x, points[i+1].y);
			}
		}
		
		Scribbler() {
			points = new Point[1000];
			addMouseMotionListener(
			  new MouseMotionAdapter() {
			    public void mouseDragged(MouseEvent me) {				
				  if (points.length == npoints) {
				  	Point[] n = new Point[2*npoints];
					for (int i = 0; i < npoints; i++) n[i] = points[i];
					points = n;
				  }
				  points[npoints++] = me.getPoint();
				  repaint(16);
			    }
			});
		}
	}
}
