// Example: the frame is the listener

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ListenerExample1 extends JFrame implements ActionListener { 
    
    private int count;
    private JButton b = new JButton("Push Me!");
    private JLabel label = new JLabel(generateLabel());
    
    public static void main (String[] args) {
        JFrame f = new ListenerExample1();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setSize(200,100);
        f.setVisible(true);
    }
    
    public ListenerExample1() {
        setLayout(new FlowLayout(FlowLayout.LEFT) );
        add(b);
        add(label);
        b.addActionListener(this);
    }
    
    public void actionPerformed (ActionEvent e) {
        count++;
        label.setText(generateLabel());
    }
    
    private String generateLabel() {
        return "Count: "+count;
    }  
}
