import java.awt.event.*;
import java.awt.*;
import javax.swing.*;

public class Example2 extends JFrame implements ActionListener {
   private final int RIGHTSIZE = 10; // 10 "tiles" on the right
   private final int LEFTSIZE = 5;   // 5 buttons on the left
   private int DELAY = 500;
   private Container cp;
   private JPanel leftPanel;
   private JPanel rightPanel;
   private JButton[] leftButtons;
   private JButton[] rightButtons;
   private JLabel message;
   private Timer scheduler;
   private int pos = RIGHTSIZE - 1;

   public static void main(String[] args) {
      JFrame frame = new Example2();   // Create a Window with "stuff" in it
      frame.setTitle("Example2");      // Give a title
      frame.setSize(100,1000);         // Give a default size of 100x100
      frame.setLocation(0,0);          // Place window in upper, left corner of screen
      frame.pack();                    // "Shrink wrap" window to fit its contents
      frame.setVisible(true);          // Show everything
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); // Kill program when window is closed
   }

   public Example2() {
      setLayout();
      addButtons();
      addLabel();
      registerListeners();
   }

   private void setLayout() {
      // 1st level: Content Pane:
      cp = getContentPane();

      // Use flow layout to place panels:
      cp.setLayout(new FlowLayout(FlowLayout.LEFT,10,10));

      // 2nd level: place panels on left and right.
      // Inside each panel, use a grid to place more components
      // which will be on the "3rd level":
      leftPanel = new JPanel();
      leftPanel.setLayout(new GridLayout(LEFTSIZE+1,1)); // "+1" because for message
      cp.add(leftPanel);

      rightPanel = new JPanel();
      rightPanel.setLayout(new GridLayout(RIGHTSIZE,1));
      cp.add(rightPanel);
   }

   private void addButtons() {
      // Create buttons on left side:
      leftButtons = new JButton[LEFTSIZE];
      leftButtons[0]=new JButton("Start");
      leftButtons[1]=new JButton("Stop");
      leftButtons[2]=new JButton("Reset");
      leftButtons[3]=new JButton("Set Delay");
      leftButtons[4]=new JButton("Quit");

      // Add buttons to left side:
      for (int count=0;count<LEFTSIZE;count++) {
         leftButtons[count].setBackground(Color.yellow);
         leftPanel.add(leftButtons[count]);
      }

      // Create buttons on right side:
      rightButtons = new JButton[RIGHTSIZE];
      for (int count = 0; count < RIGHTSIZE; count++) {
         rightButtons[count]=new JButton(""+count);
         rightButtons[count].setBackground(Color.white);
      }

      // Add buttons to right side:
      for (int count=0;count<RIGHTSIZE;count++)
         rightPanel.add(rightButtons[count]);
   }

   private void addLabel() {
      // Add Label
      message = new JLabel();
      message.setFont(new Font("Tahoma",Font.PLAIN,16));
      message.setText("Not Done!");
      message.setHorizontalAlignment(JLabel.CENTER);
      leftPanel.add(message);
   }

   private void registerListeners() {
      for (int i=0;i<LEFTSIZE;i++)
         leftButtons[i].addActionListener(this);
   }

   public void actionPerformed(ActionEvent e) {

      // Start:
      if (e.getSource()==leftButtons[0]) {

         // Do silly animation: from bottom to top, color a right button:
         scheduler = new Timer(DELAY, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
               if (pos < 0) {
                  scheduler.stop();
                  message.setText("Done!");
                  return;
               }
               rightButtons[pos].setBackground(Color.blue);
               pos--;
            }
         });
         scheduler.start();
      }

      // Stop:
      else if(e.getSource()==leftButtons[1]) {
         if (scheduler != null) scheduler.stop();
      }

      // Reset: 
      else if(e.getSource()==leftButtons[2]) {
         if (scheduler != null) scheduler.stop(); // might still be running!
         pos = RIGHTSIZE-1;
         message.setText("Not Done!");
         for (int count = 0; count < RIGHTSIZE; count++)
            rightButtons[count].setBackground(Color.white);
      }

      // Set Delay: 
      else if(e.getSource()==leftButtons[3]) {
         if (scheduler != null) scheduler.stop(); // might still be running!
         boolean stop=false;
         do {
            try {
               DELAY = Integer.parseInt(JOptionPane.showInputDialog("Enter the delay in milliseconds:"));
               if (DELAY < 0) throw new Exception();
               stop=true;
            } 
            catch(Exception exception) {
               JOptionPane.showMessageDialog(null,"Wrong type or out-of-bounds value!");
            } 
         } while(!stop);
      }

      // Quit:
      else if(e.getSource()==leftButtons[4]) {
         scheduler.stop(); // might still be running!
         switch(JOptionPane.showConfirmDialog(null,"Do you really wish to quit?",
               "Alert!",JOptionPane.YES_NO_OPTION)) {
               case JOptionPane.YES_OPTION: // quit program
                  System.exit(0);
                  break;
               case JOptionPane.NO_OPTION:  // continue
                  break;
               default:                     // unknown
                  JOptionPane.showMessageDialog(null,"Something weird just happened!");

         } // End Switch
      }

      // Something weird:
      else {
         System.err.println("Something horrible has happened!");
         System.exit(0);
      }
   } // Method ActionPerformed

} // Class Example2
