import javax.swing.*;
import java.awt.*;

public class LayoutDemo {

	public static void main(String[] args) {
		showLayout("FlowLayout", new FlowLayout());
		showLayout("GridLayout", new GridLayout(3, 3));
		showLayout("GridBagLayout", new GridBagLayout());
		showLayout("BorderLayout", new BorderLayout());
		showLayout("CardLayout", new CardLayout(5, 5));
	}

	static void showLayout(String name, LayoutManager lm) {
		JFrame top = new JFrame("Layout by " + name);
        top.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		top.setSize(300, 300);
		top.setLayout(lm);
		for (int i = 0; i < 5; i++) {
			JComponent b = new JButton("button" + i);
			Object constraint = getConstraint(lm, b, i);
			top.add(b, constraint);
		}
		top.setVisible(true);
	}
	static Object getConstraint(LayoutManager lm, JComponent b, int i) {

		if (lm instanceof GridBagLayout) {
			GridBagConstraints c = new GridBagConstraints();
			c.weightx = i; c.weighty = 1;
			return c;
		}
        if (lm instanceof BorderLayout) {
            final String[] sides = { BorderLayout.CENTER,
                                    BorderLayout.NORTH, BorderLayout.EAST,
                                    BorderLayout.SOUTH, BorderLayout.WEST };
            return sides[i];
        }
        if (lm instanceof CardLayout) {
            final String[] sides = { "1", "2", "3", "4", "5" };
            return sides[i];
        }
		return null;
	}
	
}
