import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import sun.awt.image.ToolkitImage;

public class Icons {
   
   public static void main(String[] args) {
      if (args.length == 0) System.exit(0);
      ToolkitImage ti = (ToolkitImage)new ImageIcon(args[0] + ".gif").getImage();
      BufferedImage bi = ti.getBufferedImage();
      if (bi == null) System.exit(0);
      
      //printout rgb files
      PrintStream red = null;
      PrintStream green = null;
      PrintStream blue = null;
      try {
         red = new PrintStream(args[0] + "-red.txt");
         green = new PrintStream(args[0] + "-green.txt");
         blue = new PrintStream(args[0] + "-blue.txt");
      } catch (FileNotFoundException fnf) {
         System.exit(0);
      }
      red.print("   ");
      green.print("   ");
      blue.print("   ");
      for (int x = 0; x < bi.getWidth(); x++) {
         red.format("%3d", x);
         green.format("%3d", x);
         blue.format("%3d", x);
      }
      red.println();
      green.println();
      blue.println();
      for (int y = 0; y < bi.getHeight(); y++) {
         red.format("%3d", y);
         green.format("%3d", y);
         blue.format("%3d", y);
         for (int x = 0; x < bi.getWidth(); x++) {
            Color pixel = new Color(bi.getRGB(x,y));
            red.format("%3d", pixel.getRed());
            green.format("%3d", pixel.getGreen());
            blue.format("%3d", pixel.getBlue());
         }
         red.println();
         green.println();
         blue.println();
      }
      red.close();
      green.close();
      blue.close();
      
      //get bounding box for cropping image  
      int xMin, xMax, yMin, yMax;
      if (args.length >= 5) {      
         //use supplied bounds
         xMin = Integer.parseInt(args[1]);
         xMax = Integer.parseInt(args[2]);
         yMin = Integer.parseInt(args[3]);
         yMax = Integer.parseInt(args[4]);
      } else {
         //calculate bounding box
         int x,y;
         boolean[] horiz = new boolean[bi.getWidth()];
         boolean[] vert = new boolean[bi.getHeight()];
         for (x = 0; x < bi.getWidth(); x++) {
            for (y = 0; y < bi.getHeight(); y++) {
               if ((bi.getRGB(x, y) & 0x00FFFFFF) != 0) {
                  horiz[x] = true;
                  vert[y] = true;
               }
            }
         }
         for (x = bi.getWidth()/2; x >= 0 && horiz[x]; x--) {}
         xMin = x + 1;
         for (x = bi.getWidth()/2; x < bi.getWidth() && horiz[x]; x++) {}
         xMax = x;
         for (y = bi.getHeight()/2; y >= 0 && vert[y]; y--) {}
         yMin = y + 1;
         for (y = bi.getHeight()/2; y < bi.getHeight() && vert[y]; y++) {}
         yMax = y;
      }
      
      int width = xMax - xMin;
      int height = yMax - yMin;
      System.out.format("Bounding box is xMin=%d xMax=%d yMin=%d yMax=%d\n", xMin, xMax, yMin, yMax);
      
      //crop the image      
      BufferedImage cropped = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
      int[] pixels = new int[width*height];
      bi.getRGB(xMin, yMin, width, height, pixels, 0, width);
      for (int i = 0; i < pixels.length; i++) {
         if ((pixels[i] & 0x00FFFFFF) == 0) pixels[i] = 0; //set transparency
      }
      cropped.setRGB(0, 0, width, height, pixels, 0, width);
      
      //resize to 40 x 40
      final int DIM = 40;
      pixels = new int[DIM*DIM];
      PixelGrabber pg = new PixelGrabber(cropped.getScaledInstance(DIM, DIM, Image.SCALE_SMOOTH),
            0, 0, DIM, DIM, pixels, 0, DIM);
      try {
         pg.grabPixels();
      } catch (InterruptedException ie) {}
      BufferedImage resized = new BufferedImage(DIM, DIM, BufferedImage.TYPE_INT_ARGB);
      resized.setRGB(0, 0, DIM, DIM, pixels, 0, DIM);

      //write out resized icon
      try {
         ImageIO.write(resized, "png", new File(args[0] + ".png"));
      } catch (IOException ioe) {}      
   }

}
