/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Constants;
import game.Game;
import gui.Background;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GUI
extends JFrame
implements Constants {
    private static final long serialVersionUID = 4322838670943725248L;
    private final Animator animator = new Animator();
    private final Game game;
    private final JButton startButton = new JButton("Start");
    private final Background bg;
    public final Sound openingSong = new Sound("openingSong");
    public final Sound eatDot = new Sound("eatdot");
    public final Sound eatBigDot = new Sound("eatBigDot2");
    public final Sound die = new Sound("die");
    public final Sound eatingGhosts = new Sound("eatingGhosts");
    public final Sound intermission = new Sound("intermission");
    private static boolean silent = false;

    public static void main(String[] args) {
        silent = args.length > 0 && args[0].equals("-s");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new GUI();
    }

    public GUI() {
        this.setDefaultCloseOperation(3);
        this.setTitle("CS211 Pacman");
        this.game = new Game(this);
        this.bg = new Background(this.game);
        this.add((Component)this.bg, "Center");
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.startButton);
        this.add((Component)controlPanel, "South");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (GUI.this.startButton.getText().equals("Start")) {
                    GUI.this.openingSong.playAndWait(10);
                    GUI.this.startButton.setText("Pause");
                    GUI.this.requestFocusInWindow();
                    GUI.this.game.playGame();
                    GUI.this.animator.start();
                } else if (GUI.this.startButton.getText().equals("Pause")) {
                    GUI.this.animator.stopAnimation();
                    GUI.this.startButton.setText("Resume");
                } else {
                    GUI.this.startButton.setText("Pause");
                    GUI.this.requestFocusInWindow();
                    GUI.this.restartAnimation();
                }
            }
        });
        this.startButton.setEnabled(true);
        this.addKeyListener(this.game.localPlayer);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void updateLocations(double dt) {
        this.game.updateUnits(this.game.localPlayer, dt);
        this.game.updateUnits(this.game.aiPlayer, dt);
    }

    public void stopAnimation() {
        this.animator.stopAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartAnimation() {
        Animator animator = this.animator;
        synchronized (animator) {
            this.animator.notify();
        }
    }

    class Animator
    extends Thread {
        final long FRAME_TIME = 60L;
        final double DT_MAX = 0.03;
        boolean isRunning = false;

        Animator() {
        }

        public synchronized void run() {
            long lastFrame;
            double dt = 0.0;
            long nextFrame = 0L;
            long firstFrame = lastFrame = System.currentTimeMillis();
            nextFrame = System.currentTimeMillis() + 60L;
            this.isRunning = true;
            long now = 0L;
            while (true) {
                if (this.isRunning) {
                    now = System.currentTimeMillis();
                    if (now > nextFrame) {
                        GUI.this.updateLocations(0.06);
                        GUI.this.game.checkCollisions();
                        GUI.this.bg.repaint();
                        lastFrame = now;
                        nextFrame = now + 60L;
                    }
                    if ((dt = (double)(now - lastFrame) / 1000.0) > 0.03) {
                        dt = 0.03;
                    }
                    GUI.this.bg.setAnimationTime(now - firstFrame);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.isRunning = true;
            }
        }

        public void stopAnimation() {
            this.isRunning = false;
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    public class Sound
    implements LineListener {
        private Clip clip;

        Sound(String soundFileName) {
            InputStream sound = ClassLoader.getSystemResourceAsStream("resources/sounds/" + soundFileName + ".wav");
            try {
                this.clip = AudioSystem.getClip();
                this.clip.open(AudioSystem.getAudioInputStream(sound));
                this.clip.addLineListener(this);
            }
            catch (Exception e) {
                this.clip = null;
            }
        }

        public void play() {
            if (silent || this.clip == null) {
                return;
            }
            this.clip.setFramePosition(0);
            this.clip.loop(0);
        }

        public synchronized void playAndWait(int seconds) {
            if (silent || this.clip == null) {
                return;
            }
            this.clip.setFramePosition(0);
            this.clip.loop(0);
            try {
                this.wait(seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void update(LineEvent le) {
            if (le.getType().equals(LineEvent.Type.STOP)) {
                this.notify();
            }
        }
    }
}

