/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Constants;
import game.Game;
import game.Phase;
import game.actor.Ghost;
import game.actor.Pacman;
import game.map.Cell;
import game.map.PacmanMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;

public class Background
extends JPanel
implements Constants {
    private static final long serialVersionUID = -1567109021282882103L;
    private static final String SPLASH_SCREEN_STRING = "Splash Screen...";
    protected Game game;
    protected long animationTime = 0L;
    BufferedImage backgroundImage;
    Cell[][] cellGrid;

    public Background(Game game) {
        this.game = game;
        PacmanMap map = game.map;
        this.cellGrid = map.getCellGrid();
        this.backgroundImage = map.getBackground();
        this.setPreferredSize(new Dimension(20 * map.getTileWidth(), 20 * map.getTileHeight()));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.backgroundImage, 0, 0, null);
        if (this.game.getPhase() == Phase.SPLASH_SCREEN) {
            g.setColor(Color.RED);
            g.drawString(SPLASH_SCREEN_STRING, (int)g.getClipBounds().getCenterX(), (int)g.getClipBounds().getCenterY());
        }
        this.game.drawTokens(g);
        if (this.game.getPhase() == Phase.PLAY_GAME) {
            Pacman pacman = this.game.localPlayer.getPacman();
            pacman.draw(g);
            List<Ghost> ghostList = this.game.aiPlayer.getActorList();
            for (Ghost gh : ghostList) {
                gh.draw(g);
            }
            g.drawString(" t: " + (int)(this.animationTime / 1000L) + ":" + (int)(this.animationTime / 10L % 100L), (int)g.getClipBounds().getMinX() + 200, (int)g.getClipBounds().getMinY() + 10);
        }
    }

    public long getAnimationTime() {
        return this.animationTime;
    }

    public void setAnimationTime(long animationTime) {
        this.animationTime = animationTime;
    }
}

