/*
 * Decompiled with CFR 0.152.
 */
package graph;

import game.A5RuntimeException;
import graph.Edge;
import graph.Graph;
import graph.IntPair;
import graph.KVPair;
import graph.Node;
import graph.Path;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.Vector;

public class MapGraph
implements Graph {
    public static final double INFINITY = 1.0E300;
    public static final double MAX_EDGE_WEIGHT = 1.0E100;
    protected Vector<Node> nodes = new Vector();
    protected Vector<Edge> edges = new Vector();
    protected TreeMap<IntPair, Node> nodeMap = new TreeMap();
    protected TreeMap<IntPair, Edge> edgeMap = new TreeMap();

    protected boolean addNode(Node v) {
        assert (v.id == this.nodes.size());
        assert (this.nodes.size() == this.nodeMap.size());
        if (this.nodeMap.containsKey(new IntPair(v.x, v.y))) {
            return false;
        }
        this.nodeMap.put(new IntPair(v.x, v.y), v);
        this.nodes.add(v);
        return true;
    }

    public int addNode(int x, int y) {
        int id = this.nodes.size();
        if (this.addNode(new Node(id, x, y))) {
            return id;
        }
        return -1;
    }

    public Node getNodeById(int id) {
        if (id < 0 || id >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(id);
    }

    public Node getNodeByCoord(int x, int y) {
        return this.nodeMap.get(new IntPair(x, y));
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    protected boolean addEdge(Edge e) {
        assert (e.id == this.edges.size());
        assert (this.edges.size() == this.edgeMap.size());
        if (this.edgeMap.containsKey(new IntPair(e.v1.id, e.v2.id))) {
            return false;
        }
        this.edgeMap.put(new IntPair(e.v1.id, e.v2.id), e);
        this.edges.add(e);
        e.v1.addNeighbor(e.v2);
        e.v2.addNeighbor(e.v1);
        return true;
    }

    public int addEdge(int nid1, int nid2, double weight) {
        int id = this.edges.size();
        Node v1 = this.nodes.get(nid1);
        Node v2 = this.nodes.get(nid2);
        if (nid1 != nid2 && this.addEdge(new Edge(id, v1, v2, weight))) {
            return id;
        }
        return -1;
    }

    public int addEdgeWeighedByDistance(int nid1, int nid2) {
        Node v1 = this.nodes.get(nid1);
        Node v2 = this.nodes.get(nid2);
        double dx = v1.x - v2.x;
        double dy = v1.y - v2.y;
        return this.addEdge(nid1, nid2, Math.sqrt(dx * dx + dy * dy));
    }

    public Edge getEdgeById(int id) {
        if (id < 0 || id >= this.edges.size()) {
            return null;
        }
        return this.edges.get(id);
    }

    public Edge getEdgeByEndpoints(Node v1, Node v2) {
        Edge e = this.edgeMap.get(new IntPair(v1.id, v2.id));
        if (e != null) {
            return e;
        }
        return this.edgeMap.get(new IntPair(v2.id, v1.id));
    }

    public double getEdgeWeight(Node v1, Node v2) {
        Edge e = this.getEdgeByEndpoints(v1, v2);
        if (e == null) {
            return 1.0E300;
        }
        return e.weight;
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public double pathWeight(Path p) {
        if (p.nodeCount() == 0) {
            return 1.0E300;
        }
        double weight = 0.0;
        int i = 0;
        while (i < p.nodeCount() - 1) {
            weight += this.getEdgeByEndpoints((Node)p.nodeAt((int)i), (Node)p.nodeAt((int)(i + 1))).weight;
            ++i;
        }
        return weight;
    }

    public Path shortestPath(Node src, Node dst) {
        PriorityQueue<KVPair<Double, Node>> q = new PriorityQueue<KVPair<Double, Node>>();
        double[] distance = new double[this.nodeCount()];
        Node[] parent = new Node[this.nodeCount()];
        boolean[] visited = new boolean[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            distance[i] = 1.0E300;
            parent[i] = null;
            visited[i] = false;
            ++i;
        }
        distance[dst.id] = 0.0;
        q.add(new KVPair<Double, Node>(distance[dst.id], dst));
        while (!q.isEmpty()) {
            Node v;
            KVPair front = (KVPair)q.poll();
            Node u = (Node)front.val;
            assert (distance[u.id] == (Double)front.key);
            if (u == src) {
                Path p = new Path();
                v = src;
                while (v != null) {
                    p.appendNode(v);
                    v = parent[v.id];
                }
                return p;
            }
            if (visited[u.id]) continue;
            visited[u.id] = true;
            Iterator<Node> it = u.getNeighbors();
            while (it.hasNext()) {
                v = it.next();
                if (visited[v.id]) continue;
                Edge e = this.getEdgeByEndpoints(u, v);
                if (!(distance[u.id] + e.weight < distance[v.id])) continue;
                distance[v.id] = distance[u.id] + e.weight;
                parent[v.id] = u;
                q.add(new KVPair<Double, Node>(distance[v.id], v));
            }
        }
        return new Path();
    }

    public static MapGraph readGraph(String filename) {
        Scanner sc = null;
        try {
            sc = new Scanner(new File(filename));
        }
        catch (IOException e) {
            throw new A5RuntimeException("In Graph.readGraph: Cannot open " + filename + " for reading");
        }
        MapGraph g = new MapGraph();
        try {
            int n = sc.nextInt();
            int i = 0;
            while (i < n) {
                int y;
                int x = sc.nextInt();
                if (g.addNode(x, y = sc.nextInt()) == -1) {
                    throw new A5RuntimeException("In Graph.readGraph: Duplicate coordinates detected - Abort.");
                }
                ++i;
            }
            int m = sc.nextInt();
            int i2 = 0;
            while (i2 < m) {
                int nid1 = sc.nextInt();
                int nid2 = sc.nextInt();
                double weight = sc.nextDouble();
                Node v1 = g.getNodeById(nid1);
                Node v2 = g.getNodeById(nid2);
                if (v1 == null || v2 == null) {
                    throw new A5RuntimeException("In Graph.readGraph: Invalid or corrupt input file " + filename);
                }
                if (nid1 == nid2) {
                    throw new A5RuntimeException("In Graph.readGraph: Self loop detected - Abort.");
                }
                if (weight < 0.0) {
                    double dx = v1.x - v2.x;
                    double dy = v1.y - v2.y;
                    weight = Math.sqrt(dx * dx + dy * dy);
                }
                if (weight > 1.0E100) {
                    throw new A5RuntimeException("In Graph.readGraph: Edge weight (" + weight + ") exceeded MAX_EDGE_WEIGHT (" + 1.0E100 + ")");
                }
                if (g.addEdge(nid1, nid2, weight) == -1) {
                    throw new A5RuntimeException("In Graph.readGraph: Multiple edge detected - Abort.");
                }
                ++i2;
            }
        }
        catch (RuntimeException e) {
            throw new A5RuntimeException("In Graph.readGraph: Error reading input file\n" + e.getMessage());
        }
        return g;
    }

    public void loadGraph(String filename) {
        MapGraph g = MapGraph.readGraph(filename);
        this.nodes = g.nodes;
        this.nodeMap = g.nodeMap;
        this.edges = g.edges;
        this.edgeMap = g.edgeMap;
    }

    public static void writeGraph(MapGraph g, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write(String.valueOf(g.nodeCount()) + "\n");
            int i = 0;
            while (i < g.nodeCount()) {
                Node v = g.getNodeById(i);
                out.write(String.valueOf(v.x) + " " + v.y + "\n");
                ++i;
            }
            out.write(String.valueOf(g.edgeCount()) + "\n");
            i = 0;
            while (i < g.edgeCount()) {
                Edge e = g.getEdgeById(i);
                out.write(String.valueOf(e.v1.id) + " " + e.v2.id + " " + e.weight + "\n");
                ++i;
            }
            out.flush();
        }
        catch (IOException e) {
            throw new A5RuntimeException("In Graph.writeGraph: Cannot write to " + filename);
        }
    }

    public void saveGraph(String filename) {
        MapGraph.writeGraph(this, filename);
    }

    public static void main(String[] args) {
        TreeMap<IntPair, String> m = new TreeMap<IntPair, String>();
        m.put(new IntPair(1, 2), "3");
        System.out.println(m.containsKey(new IntPair(1, 2)));
        PriorityQueue<KVPair<Integer, String>> q = new PriorityQueue<KVPair<Integer, String>>();
        q.add(new KVPair<Integer, String>(3, "three"));
        q.add(new KVPair<Integer, String>(2, "two"));
        q.add(new KVPair<Integer, String>(1, "one"));
        System.out.println((String)((KVPair)q.peek()).val);
        MapGraph g = new MapGraph();
        g.loadGraph(args[0]);
        g.saveGraph(String.valueOf(args[0]) + ".out");
        Path p = g.shortestPath(g.getNodeById(1), g.getNodeById(4));
        System.out.println("Path lenght: " + g.pathWeight(p));
        for (Node v : p) {
            System.out.println(String.valueOf(v.id) + " (" + v.x + ", " + v.y + ")");
        }
    }
}

