/*
 * Decompiled with CFR 0.152.
 */
package game.player;

import game.Constants;
import game.Game;
import game.actor.Ghost;
import game.actor.MovementDirection;
import game.map.PacmanMap;
import game.player.Player;
import graph.MapGraph;
import graph.Node;
import graph.Path;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIPlayer
extends Player
implements Constants {
    List<Ghost> ghosts = new ArrayList<Ghost>();
    Timer timer = new Timer(false);
    Random rand = new Random();

    public AIPlayer(Game game, PacmanMap map) {
        super(game);
        this.ghosts.add(new Ghost("blinky", 100.0, new Point2D.Double(240.0, 220.0), blinkyImageNames));
        this.ghosts.add(new Ghost("pinky", 85.0, new Point2D.Double(260.0, 220.0), pinkyImageNames));
        this.ghosts.add(new Ghost("inky", 70.0, new Point2D.Double(280.0, 220.0), inkyImageNames));
        this.ghosts.add(new Ghost("clyde", 55.0, new Point2D.Double(300.0, 220.0), clydeImageNames));
        this.timer.scheduleAtFixedRate((TimerTask)new MoveGhostTask(), 50L, 50L);
    }

    @Override
    public void move(double dt) {
        for (Ghost g : this.ghosts) {
            g.move(dt);
        }
    }

    public List<Ghost> getActorList() {
        return this.ghosts;
    }

    class MoveGhostTask
    extends TimerTask {
        MoveGhostTask() {
        }

        public void run() {
            this.moveGhosts();
        }

        protected void moveGhosts() {
            Point pacmanPoint = AIPlayer.this.game.localPlayer.getPacman().getCurrentCellPoint();
            MapGraph graph = AIPlayer.this.game.getMap().getGraph();
            Node pacmanNode = graph.getNodeByCoord((int)((Point2D)pacmanPoint).getX(), (int)((Point2D)pacmanPoint).getY());
            for (Ghost ghost : AIPlayer.this.ghosts) {
                Point2D ghostPoint = ghost.getCurrentCellPoint();
                Node ghostNode = graph.getNodeByCoord((int)ghostPoint.getX(), (int)ghostPoint.getY());
                Path path = graph.shortestPath(ghostNode, pacmanNode);
                if (path.nodeCount() <= 1) continue;
                Node next = path.nodeAt(1);
                ghostPoint = path.nodeAt(0).getCoordinates();
                Point2D nextPoint = next.getCoordinates();
                MovementDirection nextDir = AIPlayer.this.game.getMap().getDirection((int)(nextPoint.getX() - ghostPoint.getX()), (int)(nextPoint.getY() - ghostPoint.getY()));
                if (ghost.isVulnerable() || ghost.isRecovering()) {
                    ghost.addDirection(MovementDirection.getOpposite(nextDir));
                    continue;
                }
                ghost.addDirection(nextDir);
            }
        }
    }
}

