/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.A5FatalException;
import game.Constants;
import game.actor.MovementDirection;
import game.map.Cell;
import graph.MapGraph;
import graph.Node;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacmanMap
implements Constants {
    protected Cell[][] cellGrid;
    protected MapGraph graph;
    protected int tileWidth;
    protected int tileHeight;
    protected BufferedImage background;
    protected Point2D corralLocation;
    protected Point2D warpPoint1;
    protected Point2D warpPoint2;

    public PacmanMap() {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("resources/maps/level1.txt")));
        }
        catch (Exception e) {
            throw new A5FatalException("Could not read resource");
        }
        ArrayList<String> ls = new ArrayList<String>();
        while (true) {
            String s = null;
            try {
                s = in.readLine();
            }
            catch (Exception eof) {
                throw new A5FatalException("Could not read resource");
            }
            if (s == null) break;
            ls.add(s);
        }
        this.tileHeight = ls.size();
        this.tileWidth = ((String)ls.get(0)).length();
        this.graph = new MapGraph();
        this.background = new BufferedImage(this.tileWidth * 20, this.tileHeight * 20, 2);
        Graphics g = this.background.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.tileWidth * 20, this.tileHeight * 20);
        this.cellGrid = new Cell[this.tileWidth][this.tileHeight];
        int y = 0;
        while (y < this.tileHeight) {
            String s = (String)ls.get(y);
            int x = 0;
            while (x < this.tileWidth) {
                char c = s.charAt(x);
                this.cellGrid[x][y] = new Cell(x, y, c);
                this.cellGrid[x][y].drawBackground(g);
                if (c == 'C') {
                    this.corralLocation = new Point2D.Double(x * 20, y * 20);
                }
                if (c == 'W') {
                    if (this.warpPoint1 == null) {
                        this.warpPoint1 = new Point2D.Double(x, y);
                    } else {
                        this.warpPoint2 = new Point2D.Double(x, y);
                    }
                }
                if (this.isTraversable(x, y, true)) {
                    this.graph.addNode(x, y);
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.tileHeight) {
            int x = 0;
            while (x < this.tileWidth) {
                if (this.isTraversable(x, y, true)) {
                    for (Point2D point : this.getNeighbors(x, y, true)) {
                        Node n1 = this.graph.getNodeByCoord(x, y);
                        Node n2 = this.graph.getNodeByCoord((int)point.getX(), (int)point.getY());
                        this.graph.addEdge(n1.getId(), n2.getId(), 1.0);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public Point2D getCorralLocation() {
        return this.corralLocation;
    }

    public Cell[][] getCellGrid() {
        return this.cellGrid;
    }

    public MapGraph getGraph() {
        return this.graph;
    }

    public boolean isTraversable(int x, int y, boolean isGhost) {
        return x >= 0 && y >= 0 && x < this.tileWidth && y < this.tileHeight && this.cellGrid[x][y].isNavigable(isGhost);
    }

    public boolean canMoveDirection(int x, int y, MovementDirection direction, boolean isGhost) {
        if (this.isWarpPoint(x, y) && (direction == MovementDirection.EAST || direction == MovementDirection.WEST)) {
            return true;
        }
        switch (direction) {
            case NORTH: {
                return y > 0 && this.cellGrid[x][y - 1].isNavigable(isGhost);
            }
            case SOUTH: {
                return y < this.tileHeight - 1 && this.cellGrid[x][y + 1].isNavigable(isGhost);
            }
            case EAST: {
                return x < this.tileWidth - 1 && this.cellGrid[x + 1][y].isNavigable(isGhost);
            }
            case WEST: {
                return x > 0 && this.cellGrid[x - 1][y].isNavigable(isGhost);
            }
        }
        return false;
    }

    public Iterable<Point2D> getNeighbors(int x, int y, boolean isGhost) {
        HashSet<Point2D> neighbors = new HashSet<Point2D>();
        if (this.isTraversable(x + 1, y, isGhost)) {
            neighbors.add(new Point2D.Double(x + 1, y));
        }
        if (this.isTraversable(x - 1, y, isGhost)) {
            neighbors.add(new Point2D.Double(x - 1, y));
        }
        if (this.isTraversable(x, y - 1, isGhost)) {
            neighbors.add(new Point2D.Double(x, y - 1));
        }
        if (this.isTraversable(x, y + 1, isGhost)) {
            neighbors.add(new Point2D.Double(x, y + 1));
        }
        return neighbors;
    }

    public MovementDirection getDirection(int x, int y) {
        if (x == 1 && y == 0) {
            return MovementDirection.EAST;
        }
        if (x == -1 && y == 0) {
            return MovementDirection.WEST;
        }
        if (x == 0 && y == 1) {
            return MovementDirection.SOUTH;
        }
        return MovementDirection.NORTH;
    }

    public EnumSet<MovementDirection> getPossibleDirections(int x, int y, boolean isGhost) {
        HashSet<MovementDirection> possibleDirections = new HashSet<MovementDirection>();
        for (Point2D p : this.getNeighbors(x, y, isGhost)) {
            possibleDirections.add(this.getDirection((int)p.getX() - x, (int)p.getY() - y));
        }
        if (possibleDirections.size() == 0) {
            return EnumSet.noneOf(MovementDirection.class);
        }
        return EnumSet.copyOf(possibleDirections);
    }

    public boolean isIntersection(int tileX, int tileY, boolean isGhost) {
        int sum = 0;
        if (this.canMoveDirection(tileX, tileY, MovementDirection.NORTH, isGhost)) {
            ++sum;
        }
        if (this.canMoveDirection(tileX, tileY, MovementDirection.SOUTH, isGhost)) {
            --sum;
        }
        if (this.canMoveDirection(tileX, tileY, MovementDirection.EAST, isGhost)) {
            sum += 2;
        }
        if (this.canMoveDirection(tileX, tileY, MovementDirection.WEST, isGhost)) {
            sum -= 2;
        }
        return sum != 0;
    }

    public boolean isWarpPoint(int x, int y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        return this.warpPoint1.equals(pt) || this.warpPoint2.equals(pt);
    }

    public Point2D getMatchingWarpPoint(int x, int y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        if (this.warpPoint1.equals(pt)) {
            return this.warpPoint2;
        }
        if (this.warpPoint2.equals(pt)) {
            return this.warpPoint1;
        }
        return null;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public BufferedImage getBackground() {
        return this.background;
    }
}

