/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.Constants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Cell
implements Constants {
    public int x;
    public int y;
    public char type;

    public Cell(int x, int y, char type) {
        this.type = type;
        this.x = x;
        this.y = y;
    }

    public void drawBackground(Graphics g) {
        switch (this.type) {
            case 'e': {
                g.setColor(Color.WHITE);
                g.fillRect(this.x * 20, this.y * 20 + 10 - 1, 20, 3);
                break;
            }
            case 'h': {
                g.setColor(Color.BLUE);
                g.fillRect(this.x * 20, this.y * 20 + 10 - 1, 20, 3);
                break;
            }
            case 'v': {
                g.setColor(Color.BLUE);
                g.fillRect(this.x * 20 + 10 - 1, this.y * 20, 3, 20);
                break;
            }
            case 'm': {
                this.corner(g, -1, 1);
                break;
            }
            case 'w': {
                this.corner(g, 1, 1);
                break;
            }
            case 'f': {
                this.corner(g, -1, -1);
                break;
            }
            case 'c': {
                this.corner(g, 1, -1);
                break;
            }
        }
    }

    public void corner(Graphics g, int xSign, int ySign) {
        Rectangle oldClip = g.getClipBounds();
        g.setClip(this.x * 20, this.y * 20, 20, 20);
        int xBase = this.x * 20 + xSign * 20 / 2;
        int yBase = this.y * 20 + ySign * 20 / 2;
        g.setColor(Color.BLUE);
        g.drawOval(xBase, yBase, 20, 20);
        g.drawOval(xBase + 1, yBase + 1, 18, 18);
        g.drawOval(xBase - 1, yBase - 1, 22, 22);
        g.setClip(oldClip);
    }

    public boolean isNavigable(boolean isGhost) {
        if (isGhost) {
            return "o.*eCW".indexOf(this.type) >= 0;
        }
        return "o.*W".indexOf(this.type) >= 0;
    }

    public boolean isToken() {
        return "o.*".indexOf(this.type) >= 0;
    }
}

