/*
 * Decompiled with CFR 0.152.
 */
package game.actor;

import game.actor.Actor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class Token
extends Actor {
    private boolean isVisible = true;
    private boolean isSuperToken;

    public Token(Point2D initialLocation, boolean isSuperToken) {
        super("token", 0.0, initialLocation, tokenImageNames);
        this.isSuperToken = isSuperToken;
    }

    public void eat() {
        if (this.isVisible) {
            if (this.isSuperToken()) {
                Token.game.gui.eatBigDot.play();
            } else {
                Token.game.gui.eatDot.play();
            }
        }
        this.isVisible = false;
    }

    public void reset() {
        this.isVisible = true;
    }

    public boolean isSuperToken() {
        return this.isVisible && this.isSuperToken;
    }

    public void draw(Graphics g) {
        if (this.isVisible) {
            int x = (int)this.getCurrentPosition().getX() / 20;
            int y = (int)this.getCurrentPosition().getY() / 20;
            g.setColor(Color.WHITE);
            if (this.isSuperToken) {
                g.fillOval(x * 20 + 10 - 7, y * 20 + 10 - 7, 13, 13);
            } else {
                g.fillRect(x * 20 + 10 - 1, y * 20 + 10 - 1, 3, 3);
            }
        }
    }

    public Rectangle getBoundingBox() {
        return new Rectangle((int)this.getCurrentPosition().getX() + 5, (int)this.getCurrentPosition().getY() + 5, 5, 5);
    }
}

