/*
 * Decompiled with CFR 0.152.
 */
package game.actor;

import game.Constants;
import game.actor.MovementDirection;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class Images
implements Constants {
    private static Map<String, Image> images = new HashMap<String, Image>();
    private Map<MovementDirection, Image[]> imageMap = new HashMap<MovementDirection, Image[]>();
    private int currentIndex = 0;
    private final int N_IMAGES;
    private MovementDirection[] directions = MovementDirection.values();

    Images(String[][] names) {
        this.N_IMAGES = names[0].length;
        int i = 0;
        while (i < this.directions.length) {
            Image[] icons = new Image[this.N_IMAGES];
            int j = 0;
            while (j < this.N_IMAGES) {
                icons[j] = this.getImage(names[i][j]);
                ++j;
            }
            this.imageMap.put(this.directions[i], icons);
            ++i;
        }
    }

    private Image getImage(String name) {
        Image icon = images.get(name);
        if (icon == null) {
            icon = new ImageIcon(ClassLoader.getSystemResource("resources/icons/" + name + ".png")).getImage();
            images.put(name, icon);
        }
        return icon;
    }

    public Image getImage(MovementDirection dir, int index) {
        Image[] icons = this.imageMap.get((Object)dir);
        return icons[index % icons.length];
    }

    public Image getNextImage(MovementDirection dir) {
        this.currentIndex = (this.currentIndex + 1) % this.N_IMAGES;
        return this.getImage(dir, this.currentIndex);
    }
}

