/*
 * Decompiled with CFR 0.152.
 */
package game.actor;

import game.Constants;
import game.actor.Actor;
import game.actor.GhostState;
import game.actor.Images;
import game.actor.MovementDirection;
import java.awt.geom.Point2D;
import java.util.EnumSet;
import java.util.Timer;
import java.util.TimerTask;

public class Ghost
extends Actor {
    static final EnumSet<GhostState> MOVING = EnumSet.of(GhostState.ACTIVE, GhostState.VULNERABLE, GhostState.RECOVERING);
    public GhostState ghostState = GhostState.ACTIVE;
    public static double NEAR_THRESHOLD = 10.0;
    public static long CORRAL_TIMEOUT = 10000L;
    private Timer corralTimer = new Timer(false);
    private Images vulnerableGhostImages = new Images(Constants.vulnerableGhostImageNames);
    private Images recoveringGhostImages = new Images(Constants.recoveringGhostImageNames);

    public Ghost(String unitID, double speed, Point2D initialLocation, String[][] imagePaths) {
        super(unitID, speed, initialLocation, imagePaths);
    }

    public void makeVulnerable() {
        if (this.ghostState == GhostState.ACTIVE) {
            this.ghostState = GhostState.VULNERABLE;
            this.currentImages = this.vulnerableGhostImages;
        }
    }

    public void makeRecovering() {
        if (this.ghostState == GhostState.VULNERABLE) {
            this.ghostState = GhostState.RECOVERING;
            this.currentImages = this.recoveringGhostImages;
        }
    }

    public void makeActive() {
        if (this.ghostState == GhostState.RECOVERING || this.ghostState == GhostState.CORRAL) {
            this.ghostState = GhostState.ACTIVE;
            this.currentImages = this.standardImages;
        }
    }

    public boolean isVulnerable() {
        return this.ghostState == GhostState.VULNERABLE;
    }

    public boolean isRecovering() {
        return this.ghostState == GhostState.RECOVERING;
    }

    public boolean isActive() {
        return this.ghostState == GhostState.ACTIVE;
    }

    public void sendToCorral() {
        this.ghostState = GhostState.SEND_TO_CORRAL;
        this.corralTimer.purge();
        this.corralTimer.schedule((TimerTask)new FreeGhostTask(), CORRAL_TIMEOUT);
        this.currentImages = this.standardImages;
    }

    public void addDirection(MovementDirection newDirection) {
        if (this.currentDirection == MovementDirection.NONE) {
            this.nextDirection = this.currentDirection = newDirection;
            this.lastInterection = new Point2D.Double(-1.0, -1.0);
        } else if (newDirection == this.currentDirection) {
            this.nextDirection = newDirection;
        } else if (MovementDirection.isOpposite(this.currentDirection, newDirection)) {
            this.nextDirection = this.currentDirection = newDirection;
            this.lastInterection = new Point2D.Double(-1.0, -1.0);
        } else {
            this.nextDirection = newDirection;
        }
    }

    public void move(double dt) {
        if (MOVING.contains((Object)this.ghostState)) {
            super.move(dt);
        } else {
            Point2D corral = Ghost.game.map.getCorralLocation();
            if (!this.isNear(this.currentPosition, corral)) {
                Point2D dest = corral;
                double dx = dest.getX() - this.currentPosition.getX();
                double dy = dest.getY() - this.currentPosition.getY();
                Point2D vec = this.normalize(new Point2D.Double(dx, dy));
                this.currentPosition.setLocation(this.currentPosition.getX() + vec.getX() * this.speed / 5.0, this.currentPosition.getY() + vec.getY() * this.speed / 5.0);
            } else {
                this.currentPosition.setLocation(corral);
                this.ghostState = GhostState.CORRAL;
                this.currentImages = this.standardImages;
            }
        }
    }

    public Point2D normalize(Point2D vec) {
        double x = vec.getX();
        double y = vec.getY();
        double d_2 = x * x + y * y;
        double d_root = Math.sqrt(d_2);
        return new Point2D.Double(x / d_root, y / d_root);
    }

    public boolean isNear(Point2D pt1, Point2D pt2) {
        return pt1.distance(pt2) < NEAR_THRESHOLD;
    }

    class FreeGhostTask
    extends TimerTask {
        FreeGhostTask() {
        }

        public void run() {
            Ghost.this.ghostState = GhostState.ACTIVE;
        }
    }
}

