/*
 * Decompiled with CFR 0.152.
 */
package game.actor;

import game.Constants;
import game.Game;
import game.actor.Ghost;
import game.actor.Images;
import game.actor.MovementDirection;
import game.map.PacmanMap;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Actor
implements Constants {
    static final EnumSet<MovementDirection> SOUTH_OR_EAST = EnumSet.of(MovementDirection.SOUTH, MovementDirection.EAST);
    MovementDirection currentDirection = MovementDirection.NONE;
    MovementDirection nextDirection = MovementDirection.NONE;
    protected Point2D lastInterection = new Point2D.Double(-1.0, -1.0);
    private Point2D initialPosition;
    protected Point2D currentPosition;
    double speed;
    static Game game;
    Images standardImages;
    Images currentImages;

    public Actor(String unitType, double speed, Point2D initialPosition, String[][] imagePaths) {
        this.speed = speed;
        this.currentImages = this.standardImages = new Images(imagePaths);
        this.currentPosition = this.initialPosition = initialPosition;
    }

    public void reset() {
        this.currentPosition = this.initialPosition;
    }

    public void move(double dt) {
        Point2D newLocation = this.calculatePotentialNewLocation(dt);
        Point2D newLeadingEdge = this.convertToLeadingEdge(newLocation);
        boolean oldIntersect = false;
        int newTileX = (int)newLeadingEdge.getX() / 20;
        int newTileY = (int)newLeadingEdge.getY() / 20;
        int nlnewTileX = (int)newLocation.getX() / 20;
        int nlnewTileY = (int)newLocation.getY() / 20;
        int oldTileX = (int)this.currentPosition.getX() / 20;
        int oldTileY = (int)this.currentPosition.getY() / 20;
        int tileX = 0;
        int tileY = 0;
        if (SOUTH_OR_EAST.contains((Object)this.currentDirection)) {
            tileX = nlnewTileX;
            tileY = nlnewTileY;
        } else {
            tileX = oldTileX;
            tileY = oldTileY;
        }
        if (oldTileX != newTileX || oldTileY != newTileY) {
            PacmanMap map = Actor.game.map;
            EnumSet<MovementDirection> possibleDirections = map.getPossibleDirections(tileX, tileY, this instanceof Ghost);
            boolean isIntersection = map.isIntersection(tileX, tileY, this instanceof Ghost);
            oldIntersect = this.lastInterection.equals(new Point2D.Double(tileX, tileY));
            if (!oldIntersect && this.nextDirection != this.currentDirection && this.directionIsPossible(this.nextDirection, possibleDirections)) {
                if (isIntersection) {
                    this.lastInterection = new Point2D.Double(tileX, tileY);
                }
                this.currentPosition = new Point2D.Double(tileX * 20, tileY * 20);
                this.currentDirection = this.nextDirection;
                this.move(dt);
                return;
            }
            if (map.isTraversable(newTileX, newTileY, this instanceof Ghost)) {
                if (map.isWarpPoint(newTileX, newTileY)) {
                    Point2D warpPoint = map.getMatchingWarpPoint(newTileX, newTileY);
                    newLocation = new Point2D.Double(warpPoint.getX() * 20.0, warpPoint.getY() * 20.0);
                }
            } else {
                newLocation = this.currentPosition = new Point2D.Double(tileX * 20, tileY * 20);
                this.currentDirection = MovementDirection.NONE;
                this.nextDirection = MovementDirection.NONE;
            }
        }
        this.currentPosition = newLocation;
    }

    private boolean directionIsPossible(MovementDirection direction, Iterable<MovementDirection> possibleDirections) {
        for (MovementDirection dir : possibleDirections) {
            if (dir != direction) continue;
            return true;
        }
        return false;
    }

    private Point2D calculatePotentialNewLocation(double dt) {
        double movePotential = this.getSpeed() * dt;
        switch (this.currentDirection) {
            case NONE: {
                return this.currentPosition;
            }
            case NORTH: {
                return new Point2D.Double(this.currentPosition.getX(), this.currentPosition.getY() - movePotential);
            }
            case SOUTH: {
                return new Point2D.Double(this.currentPosition.getX(), this.currentPosition.getY() + movePotential);
            }
            case EAST: {
                return new Point2D.Double(this.currentPosition.getX() + movePotential, this.currentPosition.getY());
            }
            case WEST: {
                return new Point2D.Double(this.currentPosition.getX() - movePotential, this.currentPosition.getY());
            }
        }
        return null;
    }

    private Point2D convertToLeadingEdge(Point2D upperLeft) {
        if (this.currentDirection == MovementDirection.SOUTH) {
            return new Point2D.Double(upperLeft.getX(), upperLeft.getY() + 20.0);
        }
        if (this.currentDirection == MovementDirection.EAST) {
            return new Point2D.Double(upperLeft.getX() + 20.0, upperLeft.getY());
        }
        return upperLeft;
    }

    public void draw(Graphics g) {
        Image image = this.currentImages.getNextImage(this.currentDirection);
        g.drawImage(image, (int)this.currentPosition.getX() - 10, (int)this.currentPosition.getY() - 10, null);
    }

    public boolean collidesWith(Actor a) {
        Rectangle rect = a.getBoundingBox();
        return rect.intersects(this.getBoundingBox());
    }

    public Rectangle getBoundingBox() {
        return new Rectangle((int)this.getCurrentPosition().getX(), (int)this.getCurrentPosition().getY(), 20, 20);
    }

    public Point2D getCurrentPosition() {
        return this.currentPosition;
    }

    public Point getCurrentCellPoint() {
        Point2D p = this.getCurrentPosition();
        return new Point((int)p.getX() / 20, (int)p.getY() / 20);
    }

    public double getSpeed() {
        return this.speed;
    }

    public static void setGame(Game game) {
        Actor.game = game;
    }
}

