/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Constants;
import game.Phase;
import game.actor.Actor;
import game.actor.Ghost;
import game.actor.Pacman;
import game.actor.Token;
import game.map.Cell;
import game.map.PacmanMap;
import game.player.AIPlayer;
import game.player.LocalPlayer;
import game.player.Player;
import gui.GUI;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class Game
implements Constants {
    public final AIPlayer aiPlayer;
    public final LocalPlayer localPlayer;
    public final PacmanMap map;
    public final GUI gui;
    private Phase phase;
    private Set<Token> tokenList = new HashSet<Token>();
    private Set<Actor> actorList = new HashSet<Actor>();
    private Timer vulnerableGhostTimer;

    public Game(GUI gui) {
        this.gui = gui;
        this.map = new PacmanMap();
        Actor.setGame(this);
        Cell[][] cells = this.map.getCellGrid();
        int y = 0;
        while (y < this.map.getTileHeight()) {
            int x = 0;
            while (x < this.map.getTileWidth()) {
                if (cells[x][y].isToken()) {
                    char type = cells[x][y].type;
                    Token t = new Token(new Point2D.Double(x * 20, y * 20), type == '*');
                    this.tokenList.add(t);
                }
                ++x;
            }
            ++y;
        }
        this.localPlayer = new LocalPlayer(this);
        this.aiPlayer = new AIPlayer(this, this.map);
        this.actorList.add(this.localPlayer.getPacman());
        this.actorList.addAll(this.aiPlayer.getActorList());
        this.phase = Phase.SPLASH_SCREEN;
    }

    public void playGame() {
        this.phase = Phase.PLAY_GAME;
    }

    public void updateUnits(Player player, double dt) {
        player.move(dt);
    }

    public void drawTokens(Graphics g) {
        for (Token t : this.tokenList) {
            t.draw(g);
        }
    }

    public void checkCollisions() {
        Pacman p = this.localPlayer.getPacman();
        List<Ghost> ghosts = this.aiPlayer.getActorList();
        for (Ghost g : ghosts) {
            if (!p.collidesWith(g)) continue;
            if (g.isActive()) {
                this.gui.die.playAndWait(5);
                this.restart();
                continue;
            }
            this.gui.eatingGhosts.play();
            g.sendToCorral();
        }
        for (Token t : this.tokenList) {
            if (!p.collidesWith(t)) continue;
            if (t.isSuperToken()) {
                for (Ghost g : ghosts) {
                    g.makeVulnerable();
                }
                this.vulnerableGhostTimer = new Timer(true);
                this.vulnerableGhostTimer.schedule((TimerTask)new RecoveringTimerTask(), 7000L);
            }
            t.eat();
        }
    }

    private void restart() {
        this.gui.stopAnimation();
        for (Actor a : this.actorList) {
            a.reset();
        }
        this.gui.repaint();
        new Timer().schedule(new TimerTask(){

            public void run() {
                Game.this.gui.intermission.playAndWait(10);
                Game.this.gui.restartAnimation();
            }
        }, 1000L);
    }

    public boolean isWinner() {
        return false;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public PacmanMap getMap() {
        return this.map;
    }

    class RecoveringTimerTask
    extends TimerTask {
        RecoveringTimerTask() {
        }

        public void run() {
            for (Ghost g : Game.this.aiPlayer.getActorList()) {
                g.makeRecovering();
            }
            Game.this.vulnerableGhostTimer.schedule((TimerTask)new ActiveTimerTask(), 3000L);
        }
    }

    class ActiveTimerTask
    extends TimerTask {
        ActiveTimerTask() {
        }

        public void run() {
            for (Ghost g : Game.this.aiPlayer.getActorList()) {
                g.makeActive();
            }
        }
    }
}

