/******************************************************************************
 * Graph.java
 *
 * This file is part of CS211-fa06 Assignment 2
 *
 * Implement a graph in adjacency list format and some graph algorithms.
 * 
 * Requirement:
 * - Must extend AbstractGraph class. One may write additional methods or
 *   create addtional classes.
 * - Must override the default constructor (public Graph()).
 * - The implementation of each abstract method in AbstractGraph
 *   must satisfy the given asymptotic running time bound. Note that the
 *   specified bound are not necessarily tight (i.e. the optimal achievable
 *   asymptotical running time).
 *
 * Graph I/O Specification:
 *     The graph file is given as a pure text file. The first line has a
 * single integer n, which is the number of nodes in the graph. The next n lines
 * (line 2 -- n+1) each has two integers, delimited by a white space,
 * representing in order the x and y coordinates of the node. Since nodes
 * are added to graph sequentially, each node's sequence number (starting at 
 * zero) shall be its line number (in the input file) minus 2. After this,
 * the next line has a single integer m standing for the number of edges.
 * The following m lines each have three values: the first two integers are
 * the sequence numbers of the two endpoints of the edge and the third 
 * floating point number is the weight of the edge. If the third number 
 * is -1, the edge weight shall be the Euclidean distance between endpoints.
 */

package graph;


/*** 
 * YOU HAVE TO WRITE THIS!!!!!!
 * The main graph class - implements I/O, graph building, and some graph
 * algorithms.
 * 
 *
 */
public class MapGraph implements Graph {

	/* Constants */
	public static final double INFINITY = Double.POSITIVE_INFINITY;
	public static final double MAX_EDGE_WEIGHT = Double.MAX_VALUE;


	/* Constructor
	 */
	public MapGraph() {

	}

	// --------- Access methods ---------

	/* Add a node to the graph. Two nodes can't have the same coordinate value.
       If the x, y coordinates already exists, do nothing and return false;
       otherwise, add the node and return true.
	 */
	protected boolean addNode(Node v) {
		return false;

	}

	/* Add a node to the graph, given its x,y location.
       Return the node's id if the node is added, -1 if some node
       already exists at that location.
       - A Node object is constructed in this method.
	 */
	public int addNode(int x, int y) {
		return 0;

	}

	/* Return a node given its id.
       - Assume the id is valid.
       - This specific implementation will return null for invalid id.
	 */
	public Node getNodeById(int id) {
		return null;

	}

	/* Return a node given its x-y coordinates, null if no node at such place.
	 */
	public Node getNodeByCoord(int x, int y) {
		return null;

	}

	/* Return the number of nodes in the graph
	 */
	public int nodeCount() {
		return 0;

	}

	/* Add an edge to the graph, given the edge.
       Return true if edge is added, false if it already exists.
	 */
	protected boolean addEdge(Edge e) {
		return false;

	}

	/* Add an edge to the graph, given the two end points' ids and its weight.
       Return the edge's id if the edge is added, or -1 if adding it would form
       a multiple edge (i.e. an edge already exists betwee the two endpoints)
       or a loop (i.e. the two endpoints are one and the same). In the latter
       case (i.e. where -1 is returned), the edge shall not be added.
       - Assume the two endpoints have already been added to the graph.
       - An Edge object is constructed in this method.
	 */
	public int addEdge(int nid1, int nid2, double weight) {

		return -1;
	}

	/* Add an edge to the graph, give the ids of the two end points. The weight
       of the edge is set to the distance of the two Nodes on the x-y plane.
       Return the edge's id if the edge is added, -1 if an edge already exists
       between the two endpoints.
       - Assume the two endpoints have already been added to the graph, i.e.
         nid1 and nid2 are both valid.
	 */
	public int addEdgeWeighedByDistance(int nid1, int nid2) {
		return 0;

	}

	/* Return an edge given its id.
       - Assume the id is valid.
       - This specific implementation will return null for invalid id.
	 */
	public Edge getEdgeById(int id) {
		return null;

	}

	/* Return an edge given its two endpoints, or null if the edge dosn't exist.
       - Assume neither of v1 and v2 is null.
	 */
	public Edge getEdgeByEndpoints(Node v1, Node v2) {
		return null;

	}

	/* Return the weight of an edge given its two endpoints, or INFINITY if
       the edge doesn't exist.
       - Assume neither of v1 and v2 is null.
	 */
	public double getEdgeWeight(Node v1, Node v2) {
		return 0;

	}

	/* Return the number of edges in the graph
	 */
	public int edgeCount() {
		return 0;

	}


	// ---------- Methods related to graph algorithms ---------

	/* Computes the weight of a given path on the graph
       - Return INFINITY if p is empty, i.e. has nodeCount() == 0 (meaning 
         path doesn't exist)
       - Assume p is not null.
	 */
	public double pathWeight(Path p) {
		return 0;

	}

	/* Compute the shortest path from one node src to the dst on the graph
       (Dijkstra's algorithm)
       - Return an empty path (i.e. w/ no node) if src and dst are disconnected.
	 */
	public Path shortestPath(Node src, Node dst) {
		return null;

	}


   //---OPTIONAL---OPTIONAL---OPTIONAL---
   
   /* The following methods are OPTIONAL, you do NOT have to
    * implement them for the assignment.  However, they
    * may make testing easier.
    */

	//---------- I/O methods ----------
   
	/* Read in the graph from a file with 'filename'.
       Return the Graph object if successful, an A5RuntimeException will be
       thrown if some error has been detected.
	 */
	public static MapGraph readGraph(String filename) {
		return null;

	}

	/* load the graph by reading from a file with 'filename'. (non-static ver.)
       An A5RuntimeException will be thrown if some error has been 
       detected (e.g. the input file doesn't represent a valid graph).
       - After the call, the graph object upon which the method is 
         invoked will be updated to represent the graph specified 
         by the input file. 
	 */
	public void loadGraph(String filename) {

	}

	/* Write the graph to file withe 'filename'.
       Throws A5RuntimeException if some error has occurred.
	 */
	public static void writeGraph(MapGraph g, String filename) {

	}

	/* Non-static version of writeGraph
       Throws A5RuntimeException if some error has occurred.
	 */
	public void saveGraph(String filename) {

	}

}

/**
 * HINT!! 
 * you might want to implement and use these two classes in your graph class...
 */


/**
 * A utility class holds a pair of int
 */
class IntPair implements Comparable<IntPair> {


	public IntPair(int _first, int _second) {

	}

	public int compareTo(IntPair other) {

		return 0;
	}

	public boolean equals(IntPair other) {
		return false;

	}
}


/**
 * A utility class, holds a key-value object pair.
 * The key has Comparable type K, the object has generic type V
 */
class KVPair<K extends Comparable<K>, V> implements Comparable<KVPair<K, V> > {


	public KVPair(K _key, V _val) {

	}

	public int compareTo(KVPair<K, V> other) {
		return 0;

	}

	public boolean equals(KVPair<K, V> other) {
		return false;

	}
}

